/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MenuScroller {
    private JPopupMenu menu;
    private Component[] menuItems;
    private MenuScrollItem upItem;
    private MenuScrollItem downItem;
    private final MenuScrollListener menuListener = new MenuScrollListener();
    private int scrollCount;
    private int interval;
    private int topFixedCount;
    private int bottomFixedCount;
    private int firstIndex = 0;
    private int keepVisibleIndex = -1;

    public static MenuScroller setScrollerFor(JMenu jMenu) {
        return new MenuScroller(jMenu);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu) {
        return new MenuScroller(jPopupMenu);
    }

    public static MenuScroller setScrollerFor(JMenu jMenu, int n) {
        return new MenuScroller(jMenu, n);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n) {
        return new MenuScroller(jPopupMenu, n);
    }

    public static MenuScroller setScrollerFor(JMenu jMenu, int n, int n2) {
        return new MenuScroller(jMenu, n, n2);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n, int n2) {
        return new MenuScroller(jPopupMenu, n, n2);
    }

    public static MenuScroller setScrollerFor(JMenu jMenu, int n, int n2, int n3, int n4) {
        return new MenuScroller(jMenu, n, n2, n3, n4);
    }

    public static MenuScroller setScrollerFor(JPopupMenu jPopupMenu, int n, int n2, int n3, int n4) {
        return new MenuScroller(jPopupMenu, n, n2, n3, n4);
    }

    public MenuScroller(JMenu jMenu) {
        this(jMenu, 15);
    }

    public MenuScroller(JPopupMenu jPopupMenu) {
        this(jPopupMenu, 15);
    }

    public MenuScroller(JMenu jMenu, int n) {
        this(jMenu, n, 150);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n) {
        this(jPopupMenu, n, 150);
    }

    public MenuScroller(JMenu jMenu, int n, int n2) {
        this(jMenu, n, n2, 0, 0);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n, int n2) {
        this(jPopupMenu, n, n2, 0, 0);
    }

    public MenuScroller(JMenu jMenu, int n, int n2, int n3, int n4) {
        this(jMenu.getPopupMenu(), n, n2, n3, n4);
    }

    public MenuScroller(JPopupMenu jPopupMenu, int n, int n2, int n3, int n4) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("scrollCount and interval must be greater than 0");
        }
        if (n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("topFixedCount and bottomFixedCount cannot be negative");
        }
        this.upItem = new MenuScrollItem(MenuIcon.UP, -1);
        this.downItem = new MenuScrollItem(MenuIcon.DOWN, 1);
        this.setScrollCount(n);
        this.setInterval(n2);
        this.setTopFixedCount(n3);
        this.setBottomFixedCount(n4);
        this.menu = jPopupMenu;
        jPopupMenu.addPopupMenuListener(this.menuListener);
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("interval must be greater than 0");
        }
        this.upItem.setInterval(n);
        this.downItem.setInterval(n);
        this.interval = n;
    }

    public int getscrollCount() {
        return this.scrollCount;
    }

    public void setScrollCount(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("scrollCount must be greater than 0");
        }
        this.scrollCount = n;
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    public int getTopFixedCount() {
        return this.topFixedCount;
    }

    public void setTopFixedCount(int n) {
        this.firstIndex = this.firstIndex <= n ? n : (this.firstIndex += n - this.topFixedCount);
        this.topFixedCount = n;
    }

    public int getBottomFixedCount() {
        return this.bottomFixedCount;
    }

    public void setBottomFixedCount(int n) {
        this.bottomFixedCount = n;
    }

    public void keepVisible(JMenuItem jMenuItem) {
        int n;
        this.keepVisibleIndex = jMenuItem == null ? -1 : (n = this.menu.getComponentIndex(jMenuItem));
    }

    public void keepVisible(int n) {
        this.keepVisibleIndex = n;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.menuListener);
            this.menu = null;
        }
    }

    public void finalize() throws Throwable {
        this.dispose();
    }

    private void refreshMenu() {
        if (this.menuItems != null && this.menuItems.length > 0) {
            int n;
            this.firstIndex = Math.max(this.topFixedCount, this.firstIndex);
            this.firstIndex = Math.min(this.menuItems.length - this.bottomFixedCount - this.scrollCount, this.firstIndex);
            this.upItem.setEnabled(this.firstIndex > this.topFixedCount);
            this.downItem.setEnabled(this.firstIndex + this.scrollCount < this.menuItems.length - this.bottomFixedCount);
            this.menu.removeAll();
            for (n = 0; n < this.topFixedCount; ++n) {
                this.menu.add(this.menuItems[n]);
            }
            if (this.topFixedCount > 0) {
                this.menu.addSeparator();
            }
            this.menu.add(this.upItem);
            for (n = this.firstIndex; n < this.scrollCount + this.firstIndex; ++n) {
                this.menu.add(this.menuItems[n]);
            }
            this.menu.add(this.downItem);
            if (this.bottomFixedCount > 0) {
                this.menu.addSeparator();
            }
            for (n = this.menuItems.length - this.bottomFixedCount; n < this.menuItems.length; ++n) {
                this.menu.add(this.menuItems[n]);
            }
            JComponent jComponent = (JComponent)this.upItem.getParent();
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    static /* synthetic */ Component[] access$102(MenuScroller menuScroller, Component[] componentArray) {
        menuScroller.menuItems = componentArray;
        return componentArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MenuIcon implements Icon
    {
        UP(9, 1, 9),
        DOWN(1, 9, 1);

        final int[] xPoints = new int[]{1, 5, 9};
        final int[] yPoints;

        private MenuIcon(int ... nArray) {
            this.yPoints = nArray;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Dimension dimension = component.getSize();
            Graphics graphics2 = graphics.create(dimension.width / 2 - 5, dimension.height / 2 - 5, 10, 10);
            graphics2.setColor(Color.GRAY);
            graphics2.drawPolygon(this.xPoints, this.yPoints, 3);
            if (component.isEnabled()) {
                graphics2.setColor(Color.BLACK);
                graphics2.fillPolygon(this.xPoints, this.yPoints, 3);
            }
            graphics2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }
    }

    private class MenuScrollItem
    extends JMenuItem
    implements ChangeListener {
        private static final long serialVersionUID = 1L;
        private MenuScrollTimer timer;

        public MenuScrollItem(MenuIcon menuIcon, int n) {
            this.setIcon(menuIcon);
            this.setDisabledIcon(menuIcon);
            this.timer = new MenuScrollTimer(n, MenuScroller.this.interval);
            this.addChangeListener(this);
        }

        public void setInterval(int n) {
            this.timer.setDelay(n);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (this.isArmed() && !this.timer.isRunning()) {
                this.timer.start();
            }
            if (!this.isArmed() && this.timer.isRunning()) {
                this.timer.stop();
            }
        }
    }

    private class MenuScrollTimer
    extends Timer {
        private static final long serialVersionUID = 1L;

        public MenuScrollTimer(final int n, int n2) {
            super(n2, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MenuScroller.this.firstIndex = MenuScroller.this.firstIndex + n;
                    MenuScroller.this.refreshMenu();
                }
            });
        }
    }

    private class MenuScrollListener
    implements PopupMenuListener {
        private MenuScrollListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.setMenuItems();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.restoreMenuItems();
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.restoreMenuItems();
        }

        private void setMenuItems() {
            MenuScroller.access$102(MenuScroller.this, MenuScroller.this.menu.getComponents());
            if (MenuScroller.this.keepVisibleIndex >= MenuScroller.this.topFixedCount && MenuScroller.this.keepVisibleIndex <= MenuScroller.this.menuItems.length - MenuScroller.this.bottomFixedCount && (MenuScroller.this.keepVisibleIndex > MenuScroller.this.firstIndex + MenuScroller.this.scrollCount || MenuScroller.this.keepVisibleIndex < MenuScroller.this.firstIndex)) {
                MenuScroller.this.firstIndex = Math.min(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex);
                MenuScroller.this.firstIndex = Math.max(MenuScroller.this.firstIndex, MenuScroller.this.keepVisibleIndex - MenuScroller.this.scrollCount + 1);
            }
            if (MenuScroller.this.menuItems.length > MenuScroller.this.topFixedCount + MenuScroller.this.scrollCount + MenuScroller.this.bottomFixedCount) {
                MenuScroller.this.refreshMenu();
            }
        }

        private void restoreMenuItems() {
            MenuScroller.this.menu.removeAll();
            for (Component component : MenuScroller.this.menuItems) {
                MenuScroller.this.menu.add(component);
            }
        }
    }
}

