/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.opcache;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.concurrent.ConcurrentSoftHashMap;
import VASSAL.tools.opcache.Op;
import VASSAL.tools.opcache.OpFailedException;
import VASSAL.tools.opcache.OpObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdesktop.swingworker.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpCache {
    protected final ConcurrentMap<Key<?>, Future<?>> cache = new ConcurrentSoftHashMap();
    private static final Future<Void> failure = new Future<Void>(){

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public Void get() throws ExecutionException {
            throw new ExecutionException(new OpFailedException());
        }

        @Override
        public Void get(long l, TimeUnit timeUnit) throws ExecutionException {
            throw new ExecutionException(new OpFailedException());
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    };
    private final BlockingQueue<Runnable> requestQueue = new LinkedBlockingQueue<Runnable>();
    private final Ex threadPool = new Ex(2, 2, 60L, TimeUnit.SECONDS, this.requestQueue);

    public <V> V get(Key<V> key) {
        try {
            return this.get(key, null);
        }
        catch (CancellationException cancellationException) {
            ErrorDialog.bug(cancellationException);
        }
        catch (InterruptedException interruptedException) {
            ErrorDialog.bug(interruptedException);
        }
        catch (ExecutionException executionException) {
            ErrorDialog.bug(executionException);
        }
        return null;
    }

    public <V> V get(Key<V> key, OpObserver<V> opObserver) throws CancellationException, InterruptedException, ExecutionException {
        Future<V> future = this.getFuture(key, opObserver);
        if (opObserver == null || future.isDone()) {
            try {
                return future.get();
            }
            catch (CancellationException cancellationException) {
                this.cache.remove(key, future);
                throw (CancellationException)new CancellationException().initCause(cancellationException);
            }
            catch (InterruptedException interruptedException) {
                this.cache.remove(key, future);
                throw (InterruptedException)new InterruptedException().initCause(interruptedException);
            }
            catch (ExecutionException executionException) {
                this.cache.replace(key, future, failure);
                throw new ExecutionException(executionException);
            }
        }
        return null;
    }

    public <V> Future<V> getFuture(Key<V> key, OpObserver<V> opObserver) throws ExecutionException {
        Future future = (Future)this.cache.get(key);
        if (future == null) {
            if (opObserver == null) {
                Result result = new Result();
                future = this.cache.putIfAbsent(key, result);
                if (future == null) {
                    Object v = null;
                    try {
                        v = key.op.eval();
                    }
                    catch (Throwable throwable) {
                        result.fail();
                        this.cache.put(key, failure);
                        throw new ExecutionException(throwable);
                    }
                    finally {
                        result.set(v);
                    }
                    future = result;
                }
            } else {
                Request<V> request = new Request<V>(key, opObserver);
                future = (Future)((Object)this.cache.putIfAbsent(key, (Future<?>)((Object)request)));
                if (future == null) {
                    this.threadPool.submit(request);
                    future = request;
                }
            }
        } else if (opObserver == null && future instanceof Runnable && this.requestQueue.remove(future)) {
            ((Runnable)((Object)future)).run();
        }
        return future;
    }

    public <V> V getIfDone(Key<V> key) {
        Future future = (Future)this.cache.get(key);
        if (future != null && future.isDone()) {
            try {
                return future.get();
            }
            catch (CancellationException cancellationException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ex
    extends ThreadPoolExecutor {
        public Ex(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
            super(n, n2, l, timeUnit, blockingQueue);
        }

        public <V> Future<V> submit(SwingWorker<V, ?> swingWorker) {
            this.execute((Runnable)swingWorker);
            return swingWorker;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Request<V>
    extends SwingWorker<V, Void> {
        private final Key<V> key;
        private final OpObserver<V> obs;

        public Request(Key<V> key, OpObserver<V> opObserver) {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (opObserver == null) {
                throw new IllegalArgumentException();
            }
            this.key = key;
            this.obs = opObserver;
        }

        protected V doInBackground() throws Exception {
            return this.key.op.eval();
        }

        protected void done() {
            block7: {
                try {
                    Object object = this.get();
                    if (this.obs != null) {
                        this.obs.succeeded(this.key.op, object);
                    }
                }
                catch (CancellationException cancellationException) {
                    OpCache.this.cache.remove(this.key, (Object)this);
                    if (this.obs != null) {
                        this.obs.cancelled(this.key.op, cancellationException);
                    }
                }
                catch (InterruptedException interruptedException) {
                    OpCache.this.cache.remove(this.key, (Object)this);
                    if (this.obs != null) {
                        this.obs.interrupted(this.key.op, interruptedException);
                    }
                }
                catch (ExecutionException executionException) {
                    OpCache.this.cache.replace(this.key, (Future<?>)((Object)this), failure);
                    if (this.obs == null) break block7;
                    this.obs.failed(this.key.op, executionException);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Result<V>
    implements Future<V> {
        private static final long serialVersionUID = 1L;
        private V value = null;
        private boolean failed = false;
        private final CountDownLatch done = new CountDownLatch(1);

        private Result() {
        }

        public void set(V v) {
            this.value = v;
            this.done.countDown();
        }

        public void fail() {
            this.failed = true;
        }

        @Override
        public boolean cancel(boolean bl) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.done.getCount() == 0L;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.done.await();
            if (this.failed) {
                throw new ExecutionException(new OpFailedException());
            }
            return this.value;
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.done.await(l, timeUnit)) {
                if (this.failed) {
                    throw new ExecutionException(new OpFailedException());
                }
                return this.value;
            }
            throw new TimeoutException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key<V> {
        public final Op<V> op;
        public final int version;
        public final List<Key<?>> deps = new ArrayList();
        private final int hash;

        public Key(Op<V> op, int n) {
            this.op = op;
            this.version = n;
            for (Op<?> op2 : op.getSources()) {
                this.deps.add(op2.newKey());
            }
            this.hash = op.hashCode() ^ n ^ this.deps.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Key key = (Key)object;
            return this.version == key.version && this.op.equals(key.op) && this.deps.equals(key.deps);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[op=" + this.op + ",version=" + this.version + "]";
        }
    }
}

