/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.AWTGlyphGeometryCache;
import org.apache.batik.gvt.font.GVTFont;
import org.apache.batik.gvt.font.GVTGlyphMetrics;
import org.apache.batik.gvt.font.GVTGlyphVector;
import org.apache.batik.gvt.font.GVTLineMetrics;
import org.apache.batik.gvt.text.ArabicTextHandler;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.util.Platform;

public class AWTGVTGlyphVector
implements GVTGlyphVector {
    public static final AttributedCharacterIterator.Attribute PAINT_INFO = GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO;
    private GlyphVector awtGlyphVector;
    private AWTGVTFont gvtFont;
    private CharacterIterator ci;
    private Point2D[] defaultGlyphPositions;
    private Point2D.Float[] glyphPositions;
    private AffineTransform[] glyphTransforms;
    private Shape[] glyphOutlines;
    private Shape[] glyphVisualBounds;
    private Shape[] glyphLogicalBounds;
    private boolean[] glyphVisible;
    private GVTGlyphMetrics[] glyphMetrics;
    private GeneralPath outline;
    private Rectangle2D visualBounds;
    private Rectangle2D logicalBounds;
    private Rectangle2D bounds2D;
    private double scaleFactor;
    private float ascent;
    private float descent;
    private TextPaintInfo cacheTPI;
    private static final boolean outlinesPositioned;
    private static final boolean drawGlyphVectorWorks;
    private static final boolean glyphVectorTransformWorks;

    public AWTGVTGlyphVector(GlyphVector glyphVector, AWTGVTFont aWTGVTFont, double d, CharacterIterator characterIterator) {
        this.awtGlyphVector = glyphVector;
        this.gvtFont = aWTGVTFont;
        this.scaleFactor = d;
        this.ci = characterIterator;
        GVTLineMetrics gVTLineMetrics = this.gvtFont.getLineMetrics("By", this.awtGlyphVector.getFontRenderContext());
        this.ascent = gVTLineMetrics.getAscent();
        this.descent = gVTLineMetrics.getDescent();
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        int n = glyphVector.getNumGlyphs();
        this.glyphPositions = new Point2D.Float[n + 1];
        this.glyphTransforms = new AffineTransform[n];
        this.glyphOutlines = new Shape[n];
        this.glyphVisualBounds = new Shape[n];
        this.glyphLogicalBounds = new Shape[n];
        this.glyphVisible = new boolean[n];
        this.glyphMetrics = new GVTGlyphMetrics[n];
        for (int i = 0; i < n; ++i) {
            this.glyphVisible[i] = true;
        }
    }

    public GVTFont getFont() {
        return this.gvtFont;
    }

    public FontRenderContext getFontRenderContext() {
        return this.awtGlyphVector.getFontRenderContext();
    }

    public int getGlyphCode(int n) {
        return this.awtGlyphVector.getGlyphCode(n);
    }

    public int[] getGlyphCodes(int n, int n2, int[] nArray) {
        return this.awtGlyphVector.getGlyphCodes(n, n2, nArray);
    }

    public GlyphJustificationInfo getGlyphJustificationInfo(int n) {
        return this.awtGlyphVector.getGlyphJustificationInfo(n);
    }

    public Rectangle2D getBounds2D(AttributedCharacterIterator attributedCharacterIterator) {
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(PAINT_INFO);
        if (this.bounds2D != null && TextPaintInfo.equivilent(textPaintInfo, this.cacheTPI)) {
            return this.bounds2D;
        }
        if (textPaintInfo == null) {
            return null;
        }
        if (!textPaintInfo.visible) {
            return null;
        }
        this.cacheTPI = new TextPaintInfo(textPaintInfo);
        Shape shape = null;
        if (textPaintInfo.fillPaint != null) {
            shape = this.getOutline();
            this.bounds2D = shape.getBounds2D();
        }
        Stroke stroke = textPaintInfo.strokeStroke;
        Paint paint = textPaintInfo.strokePaint;
        if (stroke != null && paint != null) {
            if (shape == null) {
                shape = this.getOutline();
            }
            Rectangle2D rectangle2D = stroke.createStrokedShape(shape).getBounds2D();
            if (this.bounds2D == null) {
                this.bounds2D = rectangle2D;
            } else {
                this.bounds2D.add(rectangle2D);
            }
        }
        if (this.bounds2D == null) {
            return null;
        }
        if (this.bounds2D.getWidth() == 0.0 || this.bounds2D.getHeight() == 0.0) {
            this.bounds2D = null;
        }
        return this.bounds2D;
    }

    public Rectangle2D getLogicalBounds() {
        if (this.logicalBounds == null) {
            this.computeGlyphLogicalBounds();
        }
        return this.logicalBounds;
    }

    public Shape getGlyphLogicalBounds(int n) {
        if (this.glyphLogicalBounds[n] == null && this.glyphVisible[n]) {
            this.computeGlyphLogicalBounds();
        }
        return this.glyphLogicalBounds[n];
    }

    private void computeGlyphLogicalBounds() {
        int n;
        Rectangle2D rectangle2D;
        Object object;
        Shape[] shapeArray = new Shape[this.getNumGlyphs()];
        boolean[] blArray = new boolean[this.getNumGlyphs()];
        double d = -1.0;
        double d2 = -1.0;
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            float f;
            if (!this.glyphVisible[i]) {
                shapeArray[i] = null;
                continue;
            }
            AffineTransform affineTransform = this.getGlyphTransform(i);
            float f2 = 0.0f;
            float f3 = (float)((double)(-this.ascent) / this.scaleFactor);
            object = this.getGlyphMetrics(i);
            float f4 = (float)((double)((GVTGlyphMetrics)object).getHorizontalAdvance() / this.scaleFactor);
            rectangle2D = new Rectangle2D.Double(f2, f3, f4, f = (float)((double)((GVTGlyphMetrics)object).getVerticalAdvance() / this.scaleFactor));
            if (rectangle2D.isEmpty()) {
                if (i > 0) {
                    blArray[i] = blArray[i - 1];
                    continue;
                }
                blArray[i] = true;
                continue;
            }
            Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
            Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMaxX(), rectangle2D.getMinY());
            Point2D.Double double_3 = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMaxY());
            Point2D point2D = this.getGlyphPosition(i);
            AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(point2D.getX(), point2D.getY());
            if (affineTransform != null) {
                affineTransform2.concatenate(affineTransform);
            }
            affineTransform2.scale(this.scaleFactor, this.scaleFactor);
            shapeArray[i] = affineTransform2.createTransformedShape(rectangle2D);
            Point2D.Double double_4 = new Point2D.Double();
            Point2D.Double double_5 = new Point2D.Double();
            Point2D.Double double_6 = new Point2D.Double();
            affineTransform2.transform(double_, double_4);
            affineTransform2.transform(double_2, double_5);
            affineTransform2.transform(double_3, double_6);
            double d3 = ((Point2D)double_4).getX() - ((Point2D)double_5).getX();
            double d4 = ((Point2D)double_4).getX() - ((Point2D)double_6).getX();
            double d5 = ((Point2D)double_4).getY() - ((Point2D)double_5).getY();
            double d6 = ((Point2D)double_4).getY() - ((Point2D)double_6).getY();
            blArray[i] = !(Math.abs(d3) < 0.001 && Math.abs(d6) < 0.001 || Math.abs(d4) < 0.001 && Math.abs(d5) < 0.001);
            Rectangle2D rectangle2D2 = shapeArray[i].getBounds2D();
            if (rectangle2D2.getWidth() > d) {
                d = rectangle2D2.getWidth();
            }
            if (!(rectangle2D2.getHeight() > d2)) continue;
            d2 = rectangle2D2.getHeight();
        }
        GeneralPath generalPath = new GeneralPath();
        for (n = 0; n < this.getNumGlyphs(); ++n) {
            if (shapeArray[n] == null) continue;
            generalPath.append(shapeArray[n], false);
        }
        this.logicalBounds = generalPath.getBounds2D();
        if (this.logicalBounds.getHeight() < d2 * 1.5) {
            for (n = 0; n < this.getNumGlyphs(); ++n) {
                double d7;
                if (blArray[n] || shapeArray[n] == null) continue;
                object = shapeArray[n].getBounds2D();
                double d8 = ((RectangularShape)object).getMinX();
                double d9 = ((RectangularShape)object).getWidth();
                if (n < this.getNumGlyphs() - 1 && shapeArray[n + 1] != null && (rectangle2D = shapeArray[n + 1].getBounds2D()).getX() > d8 && (d7 = rectangle2D.getX() - d8) < d9 * 1.15 && d7 > d9 * 0.85) {
                    double d10 = (d7 - d9) * 0.5;
                    d9 += d10;
                    rectangle2D.setRect(rectangle2D.getX() - d10, rectangle2D.getY(), rectangle2D.getWidth() + d10, rectangle2D.getHeight());
                }
                shapeArray[n] = new Rectangle2D.Double(d8, this.logicalBounds.getMinY(), d9, this.logicalBounds.getHeight());
            }
        } else if (this.logicalBounds.getWidth() < d * 1.5) {
            for (n = 0; n < this.getNumGlyphs(); ++n) {
                double d11;
                if (blArray[n] || shapeArray[n] == null) continue;
                object = shapeArray[n].getBounds2D();
                double d12 = ((RectangularShape)object).getMinY();
                double d13 = ((RectangularShape)object).getHeight();
                if (n < this.getNumGlyphs() - 1 && shapeArray[n + 1] != null && (rectangle2D = shapeArray[n + 1].getBounds2D()).getY() > d12 && (d11 = rectangle2D.getY() - d12) < d13 * 1.15 && d11 > d13 * 0.85) {
                    double d14 = (d11 - d13) * 0.5;
                    d13 += d14;
                    rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() - d14, rectangle2D.getWidth(), rectangle2D.getHeight() + d14);
                }
                shapeArray[n] = new Rectangle2D.Double(this.logicalBounds.getMinX(), d12, this.logicalBounds.getWidth(), d13);
            }
        }
        System.arraycopy(shapeArray, 0, this.glyphLogicalBounds, 0, this.getNumGlyphs());
    }

    public GVTGlyphMetrics getGlyphMetrics(int n) {
        if (this.glyphMetrics[n] != null) {
            return this.glyphMetrics[n];
        }
        Point2D point2D = this.defaultGlyphPositions[n];
        char c = this.ci.setIndex(this.ci.getBeginIndex() + n);
        this.ci.setIndex(this.ci.getBeginIndex());
        AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c, this.awtGlyphVector, n, point2D);
        Rectangle2D rectangle2D = value.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() * this.scaleFactor, rectangle2D.getY() * this.scaleFactor, rectangle2D.getWidth() * this.scaleFactor, rectangle2D.getHeight() * this.scaleFactor);
        float f = (float)(this.defaultGlyphPositions[n + 1].getX() - this.defaultGlyphPositions[n].getX());
        this.glyphMetrics[n] = new GVTGlyphMetrics((float)((double)f * this.scaleFactor), this.ascent + this.descent, double_, 0);
        return this.glyphMetrics[n];
    }

    public Shape getGlyphOutline(int n) {
        if (this.glyphOutlines[n] == null) {
            Point2D point2D = this.defaultGlyphPositions[n];
            char c = this.ci.setIndex(this.ci.getBeginIndex() + n);
            this.ci.setIndex(this.ci.getBeginIndex());
            AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c, this.awtGlyphVector, n, point2D);
            Shape shape = value.getOutline();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphOutlines[n] = affineTransform.createTransformedShape(shape);
        }
        return this.glyphOutlines[n];
    }

    static boolean outlinesPositioned() {
        return outlinesPositioned;
    }

    public Rectangle2D getGlyphCellBounds(int n) {
        return this.getGlyphLogicalBounds(n).getBounds2D();
    }

    public Point2D getGlyphPosition(int n) {
        return this.glyphPositions[n];
    }

    public float[] getGlyphPositions(int n, int n2, float[] fArray) {
        if (fArray == null) {
            fArray = new float[n2 * 2];
        }
        for (int i = n; i < n + n2; ++i) {
            Point2D point2D = this.getGlyphPosition(i);
            fArray[(i - n) * 2] = (float)point2D.getX();
            fArray[(i - n) * 2 + 1] = (float)point2D.getY();
        }
        return fArray;
    }

    public AffineTransform getGlyphTransform(int n) {
        return this.glyphTransforms[n];
    }

    public Shape getGlyphVisualBounds(int n) {
        if (this.glyphVisualBounds[n] == null) {
            Point2D point2D = this.defaultGlyphPositions[n];
            char c = this.ci.setIndex(this.ci.getBeginIndex() + n);
            this.ci.setIndex(this.ci.getBeginIndex());
            AWTGlyphGeometryCache.Value value = AWTGVTFont.getGlyphGeometry(this.gvtFont, c, this.awtGlyphVector, n, point2D);
            Rectangle2D rectangle2D = value.getOutlineBounds2D();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.getGlyphPosition(n).getX(), this.getGlyphPosition(n).getY());
            AffineTransform affineTransform2 = this.getGlyphTransform(n);
            if (affineTransform2 != null) {
                affineTransform.concatenate(affineTransform2);
            }
            affineTransform.scale(this.scaleFactor, this.scaleFactor);
            this.glyphVisualBounds[n] = affineTransform.createTransformedShape(rectangle2D);
        }
        return this.glyphVisualBounds[n];
    }

    public int getNumGlyphs() {
        return this.awtGlyphVector.getNumGlyphs();
    }

    public Shape getOutline() {
        if (this.outline != null) {
            return this.outline;
        }
        this.outline = new GeneralPath();
        for (int i = 0; i < this.getNumGlyphs(); ++i) {
            if (!this.glyphVisible[i]) continue;
            Shape shape = this.getGlyphOutline(i);
            this.outline.append(shape, false);
        }
        return this.outline;
    }

    public Shape getOutline(float f, float f2) {
        Shape shape = this.getOutline();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public Rectangle2D getGeometricBounds() {
        if (this.visualBounds == null) {
            Shape shape = this.getOutline();
            this.visualBounds = shape.getBounds2D();
        }
        return this.visualBounds;
    }

    public void performDefaultLayout() {
        Point2D point2D;
        int n;
        if (this.defaultGlyphPositions == null) {
            this.awtGlyphVector.performDefaultLayout();
            this.defaultGlyphPositions = new Point2D.Float[this.getNumGlyphs() + 1];
            for (int i = 0; i <= this.getNumGlyphs(); ++i) {
                this.defaultGlyphPositions[i] = this.awtGlyphVector.getGlyphPosition(i);
            }
        }
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        float f = 0.0f;
        for (n = 0; n < this.getNumGlyphs(); ++n) {
            this.glyphTransforms[n] = null;
            this.glyphVisualBounds[n] = null;
            this.glyphLogicalBounds[n] = null;
            this.glyphOutlines[n] = null;
            this.glyphMetrics[n] = null;
            point2D = this.defaultGlyphPositions[n];
            float f2 = (float)(point2D.getX() * this.scaleFactor - (double)f);
            float f3 = (float)(point2D.getY() * this.scaleFactor);
            this.ci.setIndex(n + this.ci.getBeginIndex());
            if (this.glyphPositions[n] == null) {
                this.glyphPositions[n] = new Point2D.Float(f2, f3);
                continue;
            }
            this.glyphPositions[n].x = f2;
            this.glyphPositions[n].y = f3;
        }
        point2D = this.defaultGlyphPositions[n];
        this.glyphPositions[n] = new Point2D.Float((float)(point2D.getX() * this.scaleFactor - (double)f), (float)(point2D.getY() * this.scaleFactor));
    }

    public void setGlyphPosition(int n, Point2D point2D) {
        this.glyphPositions[n].x = (float)point2D.getX();
        this.glyphPositions[n].y = (float)point2D.getY();
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        if (n != this.getNumGlyphs()) {
            this.glyphVisualBounds[n] = null;
            this.glyphLogicalBounds[n] = null;
            this.glyphOutlines[n] = null;
            this.glyphMetrics[n] = null;
        }
    }

    public void setGlyphTransform(int n, AffineTransform affineTransform) {
        this.glyphTransforms[n] = affineTransform;
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        this.glyphVisualBounds[n] = null;
        this.glyphLogicalBounds[n] = null;
        this.glyphOutlines[n] = null;
        this.glyphMetrics[n] = null;
    }

    public void setGlyphVisible(int n, boolean bl) {
        if (bl == this.glyphVisible[n]) {
            return;
        }
        this.glyphVisible[n] = bl;
        this.outline = null;
        this.visualBounds = null;
        this.logicalBounds = null;
        this.bounds2D = null;
        this.glyphVisualBounds[n] = null;
        this.glyphLogicalBounds[n] = null;
        this.glyphOutlines[n] = null;
        this.glyphMetrics[n] = null;
    }

    public boolean isGlyphVisible(int n) {
        return this.glyphVisible[n];
    }

    public int getCharacterCount(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.getNumGlyphs()) {
            n2 = this.getNumGlyphs() - 1;
        }
        int n3 = 0;
        int n4 = n + this.ci.getBeginIndex();
        int n5 = n2 + this.ci.getBeginIndex();
        char c = this.ci.setIndex(n4);
        while (this.ci.getIndex() <= n5) {
            n3 += ArabicTextHandler.getNumChars(c);
            c = this.ci.next();
        }
        return n3;
    }

    public void draw(Graphics2D graphics2D, AttributedCharacterIterator attributedCharacterIterator) {
        Object object;
        int n;
        int n2 = this.getNumGlyphs();
        attributedCharacterIterator.first();
        TextPaintInfo textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute(GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO);
        if (textPaintInfo == null) {
            return;
        }
        if (!textPaintInfo.visible) {
            return;
        }
        Paint paint = textPaintInfo.fillPaint;
        Stroke stroke = textPaintInfo.strokeStroke;
        Paint paint2 = textPaintInfo.strokePaint;
        if (paint == null && (paint2 == null || stroke == null)) {
            return;
        }
        boolean bl = drawGlyphVectorWorks;
        if (bl && stroke != null && paint2 != null) {
            bl = false;
        }
        if (bl && paint != null && !(paint instanceof Color)) {
            bl = false;
        }
        if (bl) {
            Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object object3 = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            if (object2 == RenderingHints.VALUE_TEXT_ANTIALIAS_ON && object3 == RenderingHints.VALUE_STROKE_PURE) {
                bl = false;
            }
        }
        if (bl && (((n = ((AffineTransform)(object = graphics2D.getTransform())).getType()) & 0x20) != 0 || (n & 0x10) != 0)) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!this.glyphVisible[i]) {
                    bl = false;
                    break;
                }
                AffineTransform affineTransform = this.glyphTransforms[i];
                if (affineTransform == null || ((n3 = affineTransform.getType()) & 0xFFFFFFFE) == 0 || glyphVectorTransformWorks && (n3 & 0x20) == 0 && (n3 & 0x10) == 0) continue;
                bl = false;
                break;
            }
        }
        if (bl) {
            Point2D point2D;
            int n4;
            double d = this.scaleFactor;
            double[] dArray = new double[6];
            for (n4 = 0; n4 < n2; ++n4) {
                point2D = this.glyphPositions[n4];
                double d2 = ((Point2D)point2D).getX();
                double d3 = ((Point2D)point2D).getY();
                AffineTransform affineTransform = this.glyphTransforms[n4];
                if (affineTransform != null) {
                    affineTransform.getMatrix(dArray);
                    d2 += dArray[4];
                    d3 += dArray[5];
                    if (dArray[0] != 1.0 || dArray[1] != 0.0 || dArray[2] != 0.0 || dArray[3] != 1.0) {
                        dArray[4] = 0.0;
                        dArray[5] = 0.0;
                        affineTransform = new AffineTransform(dArray);
                    } else {
                        affineTransform = null;
                    }
                }
                point2D = new Point2D.Double(d2 / d, d3 / d);
                this.awtGlyphVector.setGlyphPosition(n4, point2D);
                this.awtGlyphVector.setGlyphTransform(n4, affineTransform);
            }
            graphics2D.scale(d, d);
            graphics2D.setPaint(paint);
            graphics2D.drawGlyphVector(this.awtGlyphVector, 0.0f, 0.0f);
            graphics2D.scale(1.0 / d, 1.0 / d);
            for (n4 = 0; n4 < n2; ++n4) {
                point2D = this.defaultGlyphPositions[n4];
                this.awtGlyphVector.setGlyphPosition(n4, point2D);
                this.awtGlyphVector.setGlyphTransform(n4, null);
            }
        } else {
            object = this.getOutline();
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fill((Shape)object);
            }
            if (stroke != null && paint2 != null) {
                graphics2D.setStroke(stroke);
                graphics2D.setPaint(paint2);
                graphics2D.draw((Shape)object);
            }
        }
    }

    static {
        String string = System.getProperty("java.specification.version");
        if ("1.4".compareTo(string) <= 0) {
            outlinesPositioned = true;
            drawGlyphVectorWorks = true;
            glyphVectorTransformWorks = true;
        } else if (Platform.isOSX) {
            outlinesPositioned = true;
            drawGlyphVectorWorks = false;
            glyphVectorTransformWorks = false;
        } else {
            outlinesPositioned = false;
            drawGlyphVectorWorks = true;
            glyphVectorTransformWorks = false;
        }
    }
}

