/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.wizard.displayer;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.wizard.displayer.NavButtonManager;
import org.netbeans.api.wizard.displayer.WizardDisplayerImpl;
import org.netbeans.modules.wizard.InstructionsPanel;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;

public class NavProgress
implements ResultProgressHandle {
    private static final Logger logger = Logger.getLogger(NavProgress.class.getName());
    JProgressBar progressBar = new JProgressBar();
    JLabel lbl = new JLabel();
    JLabel busy = new JLabel();
    WizardDisplayerImpl parent;
    String failMessage = null;
    boolean isUseBusy = false;
    InstructionsPanel ipanel = null;
    boolean isInitialized = false;
    boolean isRunning = true;
    static /* synthetic */ Class class$org$netbeans$api$wizard$displayer$WizardDisplayerImpl;

    NavProgress(WizardDisplayerImpl impl, boolean useBusy) {
        this.parent = impl;
        this.isUseBusy = useBusy;
    }

    public void addProgressComponents(InstructionsPanel panel) {
        panel.add(this.lbl);
        if (this.isUseBusy) {
            this.ensureBusyInitialized();
            panel.add(this.busy);
        } else {
            panel.add(this.progressBar);
        }
        this.isInitialized = true;
        this.ipanel = panel;
    }

    public void setProgress(final String description, final int currentStep, final int totalSteps) {
        Runnable r = new Runnable(){

            public void run() {
                NavProgress.this.lbl.setText(description == null ? " " : description);
                NavProgress.this.setProgress(currentStep, totalSteps);
            }
        };
        this.invoke(r);
    }

    public void setProgress(final int currentStep, final int totalSteps) {
        Runnable r = new Runnable(){

            public void run() {
                if (totalSteps == -1) {
                    NavProgress.this.progressBar.setIndeterminate(true);
                } else {
                    if (currentStep > totalSteps || currentStep < 0) {
                        if (currentStep == -1 && totalSteps == -1) {
                            return;
                        }
                        throw new IllegalArgumentException("Bad step values: " + currentStep + " out of " + totalSteps);
                    }
                    NavProgress.this.progressBar.setIndeterminate(false);
                    NavProgress.this.progressBar.setMaximum(totalSteps);
                    NavProgress.this.progressBar.setValue(currentStep);
                }
                NavProgress.this.setUseBusy(false);
            }
        };
        this.invoke(r);
    }

    public void setBusy(final String description) {
        Runnable r = new Runnable(){

            public void run() {
                NavProgress.this.lbl.setText(description == null ? " " : description);
                NavProgress.this.progressBar.setIndeterminate(true);
                NavProgress.this.setUseBusy(true);
            }
        };
        this.invoke(r);
    }

    protected void setUseBusy(boolean useBusy) {
        if (this.isInitialized) {
            if (useBusy && !this.isUseBusy) {
                this.ipanel.remove(this.progressBar);
                this.ensureBusyInitialized();
                this.ipanel.add(this.busy);
                this.ipanel.invalidate();
            } else if (!useBusy && this.isUseBusy) {
                this.ipanel.remove(this.busy);
                this.ipanel.add(this.progressBar);
                this.ipanel.invalidate();
            }
        }
        this.isUseBusy = useBusy;
    }

    private void ensureBusyInitialized() {
        if (this.busy.getIcon() == null) {
            URL url = this.getClass().getResource("busy.gif");
            ImageIcon icon = new ImageIcon(url);
            this.busy.setIcon(icon);
        }
    }

    private void invoke(Runnable r) {
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            try {
                EventQueue.invokeAndWait(r);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
                logger.severe("Error invoking operation " + ex.getClass().getName() + " " + ex.getMessage());
            }
            catch (InterruptedException ex) {
                logger.severe("Error invoking operation " + ex.getClass().getName() + " " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public void finished(final Object o) {
        this.isRunning = false;
        Runnable r = new Runnable(){

            public void run() {
                if (o instanceof Summary) {
                    Summary summary = (Summary)o;
                    NavProgress.this.parent.handleSummary(summary);
                    NavProgress.this.parent.setWizardResult(summary.getResult());
                } else if (NavProgress.this.parent.getDeferredResult() != null) {
                    NavProgress.this.parent.setWizardResult(o);
                    NavProgress.this.parent.getButtonManager().deferredResultFinished(o);
                }
            }
        };
        this.invoke(r);
    }

    public void failed(final String message, final boolean canGoBack) {
        this.failMessage = message;
        this.isRunning = false;
        Runnable r = new Runnable(){

            public void run() {
                JLabel comp = new JLabel("<html><body>" + message);
                comp.setBorder(new EmptyBorder(5, 5, 5, 5));
                NavProgress.this.parent.setCurrentWizardPanel(comp);
                NavProgress.this.parent.getTtlLabel().setText(NbBridge.getString("org/netbeans/api/wizard/Bundle", class$org$netbeans$api$wizard$displayer$WizardDisplayerImpl == null ? (class$org$netbeans$api$wizard$displayer$WizardDisplayerImpl = NavProgress.class$("org.netbeans.api.wizard.displayer.WizardDisplayerImpl")) : class$org$netbeans$api$wizard$displayer$WizardDisplayerImpl, "Failed"));
                NavButtonManager bm = NavProgress.this.parent.getButtonManager();
                bm.deferredResultFailed(canGoBack);
            }
        };
        this.invoke(r);
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

