/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect.util;

import com.cybozu.labs.langdetect.util.LangProfile;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LangProfileTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testLangProfile() {
        LangProfile profile = new LangProfile();
        Assert.assertEquals((Object)profile.name, null);
    }

    @Test
    public final void testLangProfileStringInt() {
        LangProfile profile = new LangProfile("en");
        Assert.assertEquals((Object)profile.name, (Object)"en");
    }

    @Test
    public final void testAdd() {
        LangProfile profile = new LangProfile("en");
        profile.add("a");
        Assert.assertEquals((long)profile.freq.get("a").intValue(), (long)1L);
        profile.add("a");
        Assert.assertEquals((long)profile.freq.get("a").intValue(), (long)2L);
        profile.omitLessFreq();
    }

    @Test
    public final void testAddIllegally1() {
        LangProfile profile = new LangProfile();
        profile.add("a");
        Assert.assertEquals((Object)profile.freq.get("a"), null);
    }

    @Test
    public final void testAddIllegally2() {
        LangProfile profile = new LangProfile("en");
        profile.add("a");
        profile.add("");
        profile.add("abcd");
        Assert.assertEquals((long)profile.freq.get("a").intValue(), (long)1L);
        Assert.assertEquals((Object)profile.freq.get(""), null);
        Assert.assertEquals((Object)profile.freq.get("abcd"), null);
    }

    @Test
    public final void testOmitLessFreq() {
        LangProfile profile = new LangProfile("en");
        String[] grams = "a b c \u3042 \u3044 \u3046 \u3048 \u304a \u304b \u304c \u304d \u304e \u304f".split(" ");
        int i = 0;
        while (i < 5) {
            String[] stringArray = grams;
            int n = grams.length;
            int n2 = 0;
            while (n2 < n) {
                String g = stringArray[n2];
                profile.add(g);
                ++n2;
            }
            ++i;
        }
        profile.add("\u3050");
        Assert.assertEquals((long)profile.freq.get("a").intValue(), (long)5L);
        Assert.assertEquals((long)profile.freq.get("\u3042").intValue(), (long)5L);
        Assert.assertEquals((long)profile.freq.get("\u3050").intValue(), (long)1L);
        profile.omitLessFreq();
        Assert.assertEquals((Object)profile.freq.get("a"), null);
        Assert.assertEquals((long)profile.freq.get("\u3042").intValue(), (long)5L);
        Assert.assertEquals((Object)profile.freq.get("\u3050"), null);
    }

    @Test
    public final void testOmitLessFreqIllegally() {
        LangProfile profile = new LangProfile();
        profile.omitLessFreq();
    }
}

