/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;

final class CollectionConverter
implements Converter {
    public static final CollectionConverter INSTANCE = new CollectionConverter();
    private static final TypeVariable<?> TYPE_VARIABLE;

    CollectionConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Collection.class.isAssignableFrom(cls);
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return null;
        }
        Type pt = context.getResolvedType(t, c, TYPE_VARIABLE);
        Class<?> pc = ClassUtil.getRawType(pt);
        JSONHint hint = context.getHint();
        Collection collection = null;
        if (value instanceof List) {
            List src = (List)value;
            context.createSizeHint = src.size();
            collection = (Collection)context.createInternal(c);
            context.createSizeHint = -1;
            if (Object.class.equals(pc)) {
                collection.addAll(src);
            } else {
                for (int i = 0; i < src.size(); ++i) {
                    context.enter(i, hint);
                    collection.add(context.postparseInternal(src.get(i), pc, pt));
                    context.exit();
                }
            }
        } else if (value instanceof Map) {
            TreeMap map = (TreeMap)value;
            if (!(map instanceof SortedMap)) {
                map = new TreeMap(map);
            }
            Collection src = map.values();
            context.createSizeHint = src.size();
            collection = (Collection)context.createInternal(c);
            context.createSizeHint = -1;
            if (Object.class.equals(pc)) {
                collection.addAll(src);
            } else {
                Iterator it = src.iterator();
                int i = 0;
                while (it.hasNext()) {
                    context.enter(i, hint);
                    collection.add(context.postparseInternal(it.next(), pc, pt));
                    context.exit();
                    ++i;
                }
            }
        } else if (value instanceof Collection) {
            Collection src = (Collection)value;
            context.createSizeHint = src.size();
            collection = (Collection)context.createInternal(c);
            context.createSizeHint = -1;
            if (Object.class.equals(pc)) {
                collection.addAll(src);
            } else {
                Iterator it = src.iterator();
                int i = 0;
                while (it.hasNext()) {
                    context.enter(i, hint);
                    collection.add(context.postparseInternal(it.next(), pc, pt));
                    context.exit();
                    ++i;
                }
            }
        } else {
            context.createSizeHint = 1;
            collection = (Collection)context.createInternal(c);
            context.createSizeHint = -1;
            if (Object.class.equals(pc)) {
                collection.add(value);
            } else {
                context.enter(0, hint);
                collection.add(context.postparseInternal(value, pc, pt));
                context.exit();
            }
        }
        return collection;
    }

    static {
        TypeVariable<Class<T>>[] params = Collection.class.getTypeParameters();
        TYPE_VARIABLE = params[0];
    }
}

