/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.OverseerCollectionMessageHandler;
import org.apache.solr.common.NonExistentCoreException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.snapshots.SolrSnapshotManager;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteCollectionCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public DeleteCollectionCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        String collection = message.getStr("name");
        try {
            SolrZkClient zkClient = zkStateReader.getZkClient();
            SolrSnapshotManager.cleanupCollectionLevelSnapshots(zkClient, collection);
            if (zkStateReader.getClusterState().getCollectionOrNull(collection) == null && zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                return;
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CoreAdminParams.CoreAdminAction.UNLOAD.toString()});
            params.set("deleteInstanceDir", true);
            params.set("deleteDataDir", true);
            String asyncId = message.getStr("async");
            HashMap<String, String> requestMap = null;
            if (asyncId != null) {
                requestMap = new HashMap<String, String>();
            }
            HashSet<String> okayExceptions = new HashSet<String>(1);
            okayExceptions.add(NonExistentCoreException.class.getName());
            this.ocmh.collectionCmd(message, params, results, null, asyncId, requestMap, okayExceptions);
            ZkNodeProps m = new ZkNodeProps(new String[]{"operation", CollectionParams.CollectionAction.DELETE.toLower(), "name", collection});
            Overseer.getStateUpdateQueue(zkStateReader.getZkClient()).offer(Utils.toJSON((Object)m));
            TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS);
            boolean removed = false;
            while (!timeout.hasTimedOut()) {
                Thread.sleep(100L);
                removed = !zkStateReader.getClusterState().hasCollection(collection);
                if (!removed) continue;
                Thread.sleep(500L);
                break;
            }
            if (!removed) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not fully remove collection: " + collection);
            }
        }
        finally {
            try {
                if (zkStateReader.getZkClient().exists("/collections/" + collection, true).booleanValue()) {
                    zkStateReader.getZkClient().clean("/collections/" + collection);
                }
            }
            catch (InterruptedException e) {
                SolrException.log((Logger)log, (String)("Cleaning up collection in zk was interrupted:" + collection), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (KeeperException e) {
                SolrException.log((Logger)log, (String)("Problem cleaning up collection in zk:" + collection), (Throwable)e);
            }
        }
    }
}

