﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudfront/CloudFront_EXPORTS.h>
#include <aws/cloudfront/model/KGKeyPairIds.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace CloudFront {
namespace Model {

/**
 * <p>A list of key groups, and the public keys in each key group, that CloudFront
 * can use to verify the signatures of signed URLs and signed
 * cookies.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ActiveTrustedKeyGroups">AWS
 * API Reference</a></p>
 */
class ActiveTrustedKeyGroups {
 public:
  AWS_CLOUDFRONT_API ActiveTrustedKeyGroups() = default;
  AWS_CLOUDFRONT_API ActiveTrustedKeyGroups(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_CLOUDFRONT_API ActiveTrustedKeyGroups& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_CLOUDFRONT_API void AddToNode(Aws::Utils::Xml::XmlNode& parentNode) const;

  ///@{
  /**
   * <p>This field is <code>true</code> if any of the key groups have public keys
   * that CloudFront can use to verify the signatures of signed URLs and signed
   * cookies. If not, this field is <code>false</code>.</p>
   */
  inline bool GetEnabled() const { return m_enabled; }
  inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }
  inline void SetEnabled(bool value) {
    m_enabledHasBeenSet = true;
    m_enabled = value;
  }
  inline ActiveTrustedKeyGroups& WithEnabled(bool value) {
    SetEnabled(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of key groups in the list.</p>
   */
  inline int GetQuantity() const { return m_quantity; }
  inline bool QuantityHasBeenSet() const { return m_quantityHasBeenSet; }
  inline void SetQuantity(int value) {
    m_quantityHasBeenSet = true;
    m_quantity = value;
  }
  inline ActiveTrustedKeyGroups& WithQuantity(int value) {
    SetQuantity(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of key groups, including the identifiers of the public keys in each
   * key group that CloudFront can use to verify the signatures of signed URLs and
   * signed cookies.</p>
   */
  inline const Aws::Vector<KGKeyPairIds>& GetItems() const { return m_items; }
  inline bool ItemsHasBeenSet() const { return m_itemsHasBeenSet; }
  template <typename ItemsT = Aws::Vector<KGKeyPairIds>>
  void SetItems(ItemsT&& value) {
    m_itemsHasBeenSet = true;
    m_items = std::forward<ItemsT>(value);
  }
  template <typename ItemsT = Aws::Vector<KGKeyPairIds>>
  ActiveTrustedKeyGroups& WithItems(ItemsT&& value) {
    SetItems(std::forward<ItemsT>(value));
    return *this;
  }
  template <typename ItemsT = KGKeyPairIds>
  ActiveTrustedKeyGroups& AddItems(ItemsT&& value) {
    m_itemsHasBeenSet = true;
    m_items.emplace_back(std::forward<ItemsT>(value));
    return *this;
  }
  ///@}
 private:
  bool m_enabled{false};

  int m_quantity{0};

  Aws::Vector<KGKeyPairIds> m_items;
  bool m_enabledHasBeenSet = false;
  bool m_quantityHasBeenSet = false;
  bool m_itemsHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFront
}  // namespace Aws
