/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.GetWikipediaXmlHandler;
import tim.prune.function.search.SearchResult;

public class SearchWikipediaNames
extends GenericDownloaderFunction {
    private String _searchTerm = null;
    private static final int MAX_RESULTS = 20;
    private static final String GEONAMES_USERNAME = "gpsprune";

    public SearchWikipediaNames(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.searchwikipedianames";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return null;
    }

    @Override
    public void begin() {
        Object object = JOptionPane.showInputDialog(this._app.getFrame(), I18nManager.getText("dialog.searchwikipedianames.search"), this.getName(), 3, null, null, "");
        if (object != null) {
            this._searchTerm = object.toString().toLowerCase();
            if (!this._searchTerm.equals("")) {
                super.begin();
            }
        }
    }

    @Override
    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        String string = SearchWikipediaNames.encodeSearchTerm(this._searchTerm);
        String string2 = I18nManager.getText("wikipedia.lang");
        this.submitSearch(string, string2);
        if (this._trackListModel.isEmpty() && this._errorMessage == null && string2.equals("als")) {
            this.submitSearch(string, "de");
        }
        if (this._trackListModel.isEmpty() && this._errorMessage == null && !string2.equals("en")) {
            this.submitSearch(string, "en");
        }
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.wikipedia.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
        this.finishedSearch();
    }

    private void submitSearch(String string, String string2) {
        Serializable serializable;
        String string3 = "http://api.geonames.org/wikipediaSearch?title=" + string + "&maxRows=" + 20 + "&lang=" + string2 + "&username=" + GEONAMES_USERNAME;
        GetWikipediaXmlHandler getWikipediaXmlHandler = new GetWikipediaXmlHandler();
        InputStream inputStream = null;
        try {
            serializable = new URL(string3);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            inputStream = serializable.openStream();
            sAXParser.parse(inputStream, (DefaultHandler)getWikipediaXmlHandler);
        }
        catch (Exception exception) {
            this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        serializable = getWikipediaXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<SearchResult>)serializable);
    }

    static String encodeSearchTerm(String string) {
        String string2;
        String string3 = string2 = string == null ? "" : string.trim();
        if (string2.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case '\u00fc': {
                    stringBuilder.append("ue");
                    break;
                }
                case '\u00e4': {
                    stringBuilder.append("ae");
                    break;
                }
                case '\u00f6': {
                    stringBuilder.append("oe");
                    break;
                }
                case '\u00df': {
                    stringBuilder.append("ss");
                    break;
                }
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': {
                    stringBuilder.append('e');
                    break;
                }
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': {
                    stringBuilder.append('a');
                    break;
                }
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': {
                    stringBuilder.append('o');
                    break;
                }
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': {
                    stringBuilder.append('i');
                    break;
                }
                case '\u00e7': {
                    stringBuilder.append('c');
                    break;
                }
                case '\u015f': {
                    stringBuilder.append('s');
                    break;
                }
                case '\u00f1': {
                    stringBuilder.append('n');
                    break;
                }
                case '\u0142': {
                    stringBuilder.append('l');
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            ++n2;
        }
        return URLEncoder.encode(stringBuilder.toString(), StandardCharsets.UTF_8);
    }
}

