/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.u2f;

import java.security.interfaces.ECPublicKey;
import java.util.Objects;
import org.apache.sshd.common.config.keys.u2f.SecurityKeyPublicKey;

public class SkEcdsaPublicKey
implements SecurityKeyPublicKey<ECPublicKey> {
    public static final String ALGORITHM = "ECDSA-SK";
    private static final long serialVersionUID = -8758432826838775097L;
    private final String appName;
    private final boolean noTouchRequired;
    private final ECPublicKey delegatePublicKey;

    public SkEcdsaPublicKey(String appName, boolean noTouchRequired, ECPublicKey delegatePublicKey) {
        this.appName = appName;
        this.noTouchRequired = noTouchRequired;
        this.delegatePublicKey = delegatePublicKey;
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getKeyType() {
        return "sk-ecdsa-sha2-nistp256@openssh.com";
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public boolean isNoTouchRequired() {
        return this.noTouchRequired;
    }

    @Override
    public ECPublicKey getDelegatePublicKey() {
        return this.delegatePublicKey;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[appName=" + this.getAppName() + ", noTouchRequired=" + this.isNoTouchRequired() + ", delegatePublicKey=" + this.getDelegatePublicKey() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.appName, this.noTouchRequired, this.delegatePublicKey);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SkEcdsaPublicKey other = (SkEcdsaPublicKey)obj;
        return Objects.equals(this.appName, other.appName) && this.noTouchRequired == other.noTouchRequired && Objects.equals(this.delegatePublicKey, other.delegatePublicKey);
    }
}

