/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Locale;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.CredentialsUtil;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.ccache.CredentialsCache;
import sun.security.krb5.internal.crypto.EType;

public class Credentials {
    Ticket ticket;
    PrincipalName client;
    PrincipalName clientAlias;
    PrincipalName server;
    PrincipalName serverAlias;
    EncryptionKey key;
    TicketFlags flags;
    KerberosTime authTime;
    KerberosTime startTime;
    KerberosTime endTime;
    KerberosTime renewTill;
    HostAddresses cAddr;
    AuthorizationData authzData;
    private static boolean DEBUG = Krb5.DEBUG;
    private static CredentialsCache cache;
    static boolean alreadyLoaded;
    private static boolean alreadyTried;
    private Credentials proxy = null;

    public Credentials getProxy() {
        return this.proxy;
    }

    public Credentials setProxy(Credentials credentials) {
        this.proxy = credentials;
        return this;
    }

    private static native Credentials acquireDefaultNativeCreds(int[] var0);

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, PrincipalName principalName3, PrincipalName principalName4, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses, AuthorizationData authorizationData) {
        this(ticket, principalName, principalName2, principalName3, principalName4, encryptionKey, ticketFlags, kerberosTime, kerberosTime2, kerberosTime3, kerberosTime4, hostAddresses);
        this.authzData = authorizationData;
    }

    public Credentials(Ticket ticket, PrincipalName principalName, PrincipalName principalName2, PrincipalName principalName3, PrincipalName principalName4, EncryptionKey encryptionKey, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, HostAddresses hostAddresses) {
        this.ticket = ticket;
        this.client = principalName;
        this.clientAlias = principalName2;
        this.server = principalName3;
        this.serverAlias = principalName4;
        this.key = encryptionKey;
        this.flags = ticketFlags;
        this.authTime = kerberosTime;
        this.startTime = kerberosTime2;
        this.endTime = kerberosTime3;
        this.renewTill = kerberosTime4;
        this.cAddr = hostAddresses;
    }

    public Credentials(byte[] byArray, String string, String string2, String string3, String string4, byte[] byArray2, int n, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) throws KrbException, IOException {
        this(new Ticket(byArray), new PrincipalName(string, 1), string2 == null ? null : new PrincipalName(string2, 1), new PrincipalName(string3, 2), string4 == null ? null : new PrincipalName(string4, 2), new EncryptionKey(n, byArray2), blArray == null ? null : new TicketFlags(blArray), date == null ? null : new KerberosTime(date), date2 == null ? null : new KerberosTime(date2), date3 == null ? null : new KerberosTime(date3), date4 == null ? null : new KerberosTime(date4), null);
    }

    public final PrincipalName getClient() {
        return this.client;
    }

    public final PrincipalName getClientAlias() {
        return this.clientAlias;
    }

    public final PrincipalName getServer() {
        return this.server;
    }

    public final PrincipalName getServerAlias() {
        return this.serverAlias;
    }

    public final EncryptionKey getSessionKey() {
        return this.key;
    }

    public final Date getAuthTime() {
        if (this.authTime != null) {
            return this.authTime.toDate();
        }
        return null;
    }

    public final Date getStartTime() {
        if (this.startTime != null) {
            return this.startTime.toDate();
        }
        return null;
    }

    public final Date getEndTime() {
        if (this.endTime != null) {
            return this.endTime.toDate();
        }
        return null;
    }

    public final Date getRenewTill() {
        if (this.renewTill != null) {
            return this.renewTill.toDate();
        }
        return null;
    }

    public final boolean[] getFlags() {
        if (this.flags == null) {
            return null;
        }
        return this.flags.toBooleanArray();
    }

    public final InetAddress[] getClientAddresses() {
        if (this.cAddr == null) {
            return null;
        }
        return this.cAddr.getInetAddresses();
    }

    public final byte[] getEncoded() {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                byArray = this.ticket.asn1Encode();
            }
            catch (Asn1Exception asn1Exception) {
                if (DEBUG) {
                    System.out.println(asn1Exception);
                }
            }
            catch (IOException iOException) {
                if (!DEBUG) break block4;
                System.out.println(iOException);
            }
        }
        return byArray;
    }

    public boolean isForwardable() {
        return this.flags.get(1);
    }

    public boolean isRenewable() {
        return this.flags.get(8);
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public AuthorizationData getAuthzData() {
        return this.authzData;
    }

    public boolean checkDelegate() {
        return this.flags.get(13);
    }

    public void resetDelegate() {
        this.flags.set(13, false);
    }

    public Credentials renew() throws KrbException, IOException {
        KDCOptions kDCOptions = new KDCOptions();
        kDCOptions.set(30, true);
        kDCOptions.set(8, true);
        return new KrbTgsReq(kDCOptions, this, this.server, this.serverAlias, null, null, null, null, this.cAddr, null, null, null).sendAndGetCreds();
    }

    public static Credentials acquireTGTFromCache(PrincipalName principalName, String string) throws KrbException, IOException {
        Object object;
        if (string == null && (((String)(object = AccessController.doPrivileged(new GetPropertyAction("os.name")))).toUpperCase(Locale.ENGLISH).startsWith("WINDOWS") || ((String)object).toUpperCase(Locale.ENGLISH).contains("OS X"))) {
            Credentials credentials = Credentials.acquireDefaultCreds();
            if (credentials == null) {
                if (DEBUG) {
                    System.out.println(">>> Found no TGT's in LSA");
                }
                return null;
            }
            if (principalName != null) {
                if (credentials.getClient().equals(principalName)) {
                    if (DEBUG) {
                        System.out.println(">>> Obtained TGT from LSA: " + credentials);
                    }
                    return credentials;
                }
                if (DEBUG) {
                    System.out.println(">>> LSA contains TGT for " + credentials.getClient() + " not " + principalName);
                }
                return null;
            }
            if (DEBUG) {
                System.out.println(">>> Obtained TGT from LSA: " + credentials);
            }
            return credentials;
        }
        object = CredentialsCache.getInstance(principalName, string);
        if (object == null) {
            return null;
        }
        Credentials credentials = ((CredentialsCache)object).getInitialCreds();
        if (credentials == null) {
            return null;
        }
        if (EType.isSupported(credentials.key.getEType())) {
            return credentials;
        }
        if (DEBUG) {
            System.out.println(">>> unsupported key type found the default TGT: " + credentials.key.getEType());
        }
        return null;
    }

    public static synchronized Credentials acquireDefaultCreds() {
        Credentials credentials;
        Credentials credentials2 = null;
        if (cache == null) {
            cache = CredentialsCache.getInstance();
        }
        if (cache != null && (credentials = cache.getInitialCreds()) != null) {
            if (DEBUG) {
                System.out.println(">>> KrbCreds found the default ticket granting ticket in credential cache.");
            }
            if (EType.isSupported(credentials.key.getEType())) {
                credentials2 = credentials;
            } else if (DEBUG) {
                System.out.println(">>> unsupported key type found the default TGT: " + credentials.key.getEType());
            }
        }
        if (credentials2 == null) {
            if (!alreadyTried) {
                try {
                    Credentials.ensureLoaded();
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println("Can not load credentials cache");
                        exception.printStackTrace();
                    }
                    alreadyTried = true;
                }
            }
            if (alreadyLoaded) {
                if (DEBUG) {
                    System.out.println(">> Acquire default native Credentials");
                }
                try {
                    credentials2 = Credentials.acquireDefaultNativeCreds(EType.getDefaults("default_tkt_enctypes"));
                }
                catch (KrbException krbException) {
                    // empty catch block
                }
            }
        }
        return credentials2;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireServiceCreds(string, credentials);
    }

    public static Credentials acquireS4U2selfCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2selfCreds(principalName, credentials);
    }

    public static Credentials acquireS4U2proxyCreds(String string, Ticket ticket, PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.acquireS4U2proxyCreds(string, ticket, principalName, credentials);
    }

    public CredentialsCache getCache() {
        return cache;
    }

    public static void printDebug(Credentials credentials) {
        System.out.println(">>> DEBUG: ----Credentials----");
        System.out.println("\tclient: " + credentials.client.toString());
        if (credentials.clientAlias != null) {
            System.out.println("\tclient alias: " + credentials.clientAlias.toString());
        }
        System.out.println("\tserver: " + credentials.server.toString());
        if (credentials.serverAlias != null) {
            System.out.println("\tserver alias: " + credentials.serverAlias.toString());
        }
        System.out.println("\tticket: sname: " + credentials.ticket.sname.toString());
        if (credentials.startTime != null) {
            System.out.println("\tstartTime: " + credentials.startTime.getTime());
        }
        System.out.println("\tendTime: " + credentials.endTime.getTime());
        System.out.println("        ----Credentials end----");
    }

    static void ensureLoaded() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.getProperty("os.name").contains("OS X")) {
                    System.loadLibrary("osxkrb5");
                } else {
                    System.loadLibrary("w2k_lsa_auth");
                }
                return null;
            }
        });
        alreadyLoaded = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Credentials:");
        stringBuffer.append("\n      client=").append(this.client);
        if (this.clientAlias != null) {
            stringBuffer.append("\n      clientAlias=").append(this.clientAlias);
        }
        stringBuffer.append("\n      server=").append(this.server);
        if (this.serverAlias != null) {
            stringBuffer.append("\n      serverAlias=").append(this.serverAlias);
        }
        if (this.authTime != null) {
            stringBuffer.append("\n    authTime=").append(this.authTime);
        }
        if (this.startTime != null) {
            stringBuffer.append("\n   startTime=").append(this.startTime);
        }
        stringBuffer.append("\n     endTime=").append(this.endTime);
        stringBuffer.append("\n   renewTill=").append(this.renewTill);
        stringBuffer.append("\n       flags=").append(this.flags);
        stringBuffer.append("\nEType (skey)=").append(this.key.getEType());
        stringBuffer.append("\n   (tkt key)=").append(this.ticket.encPart.eType);
        return stringBuffer.toString();
    }

    public sun.security.krb5.internal.ccache.Credentials toCCacheCreds() {
        return new sun.security.krb5.internal.ccache.Credentials(this.getClient(), this.getServer(), this.getSessionKey(), Credentials.date2kt(this.getAuthTime()), Credentials.date2kt(this.getStartTime()), Credentials.date2kt(this.getEndTime()), Credentials.date2kt(this.getRenewTill()), false, this.flags, new HostAddresses(this.getClientAddresses()), this.getAuthzData(), this.getTicket(), null);
    }

    private static KerberosTime date2kt(Date date) {
        return date == null ? null : new KerberosTime(date);
    }

    static {
        alreadyLoaded = false;
        alreadyTried = false;
    }
}

