/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.PathHelper;
import org.hibernate.query.sqm.SqmJoinable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddableDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.spi.NavigablePath;

public class EmbeddedSqmPathSource<J>
extends AbstractSqmPathSource<J>
implements CompositeSqmPathSource<J> {
    private final boolean isGeneric;
    private final SqmEmbeddableDomainType<J> domainType;

    public EmbeddedSqmPathSource(String localPathName, SqmPathSource<J> pathModel, SqmEmbeddableDomainType<J> domainType, Bindable.BindableType jpaBindableType, boolean isGeneric) {
        super(localPathName, pathModel, domainType, jpaBindableType);
        this.domainType = domainType;
        this.isGeneric = isGeneric;
    }

    @Override
    public SqmEmbeddableDomainType<J> getPathType() {
        return this.domainType;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.getPathType().findSubPathSource(name);
    }

    @Override
    public boolean isGeneric() {
        return this.isGeneric;
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath;
        SqmPathSource sqmPathSource = this.pathModel;
        if (sqmPathSource instanceof SqmJoinable) {
            SqmJoinable sqmJoinable = (SqmJoinable)((Object)sqmPathSource);
            navigablePath = sqmJoinable.createNavigablePath(lhs, null);
        } else {
            navigablePath = PathHelper.append(lhs, this, intermediatePathSource);
        }
        return new SqmEmbeddedValuedSimplePath(navigablePath, this.pathModel, lhs, lhs.nodeBuilder());
    }
}

