/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.lang.reflect.Method;
import org.hibernate.mapping.Component;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.type.ComponentType;

public class EmbeddedComponentType
extends ComponentType {
    public EmbeddedComponentType(Component component, int[] originalPropertyOrder) {
        super(component, originalPropertyOrder);
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean isMethodOf(Method method) {
        if (this.mappingModelPart() == null) {
            throw new IllegalStateException("EmbeddableValuedModelPart not known yet");
        }
        EmbeddableMappingType embeddable = this.mappingModelPart().getEmbeddableTypeDescriptor();
        for (int i = 0; i < embeddable.getNumberOfAttributeMappings(); ++i) {
            AttributeMapping attributeMapping = embeddable.getAttributeMapping(i);
            Getter getter = attributeMapping.getPropertyAccess().getGetter();
            Method getterMethod = getter.getMethod();
            if (getterMethod == null || !getterMethod.equals(method)) continue;
            return true;
        }
        return false;
    }
}

