/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public final class ContextClassLoaderInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = 3727922476337147374L;
    private final ClassLoader classLoader;

    public ContextClassLoaderInterceptor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        ClassLoader old;
        Thread thread = Thread.currentThread();
        if (System.getSecurityManager() == null) {
            old = thread.getContextClassLoader();
            thread.setContextClassLoader(this.classLoader);
        } else {
            old = AccessController.doPrivileged(new SetContextClassLoader(this.classLoader));
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            if (System.getSecurityManager() == null) {
                thread.setContextClassLoader(old);
            } else {
                AccessController.doPrivileged(new SetContextClassLoader(old));
            }
        }
    }

    private static class SetContextClassLoader
    implements PrivilegedAction<ClassLoader> {
        private final ClassLoader classLoader;

        private SetContextClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader run() {
            Thread thread = Thread.currentThread();
            ClassLoader old = thread.getContextClassLoader();
            thread.setContextClassLoader(this.classLoader);
            return old;
        }
    }
}

