/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.compatibility;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.compatibility.CompatibilityResult;
import org.keycloak.compatibility.ProviderIncompatibleResult;

record AggregatedCompatibilityResult(Set<CompatibilityResult> compatibilityResults) implements CompatibilityResult
{
    public AggregatedCompatibilityResult(CompatibilityResult compatibilityResult) {
        this(new HashSet<CompatibilityResult>());
        this.compatibilityResults.add(compatibilityResult);
    }

    public AggregatedCompatibilityResult add(CompatibilityResult a) {
        this.compatibilityResults.add(a);
        return this;
    }

    @Override
    public int exitCode() {
        return this.compatibilityResults.stream().anyMatch(r -> r.exitCode() == CompatibilityResult.ExitCode.RECREATE.value()) ? CompatibilityResult.ExitCode.RECREATE.value() : CompatibilityResult.ExitCode.ROLLING.value();
    }

    @Override
    public Optional<String> errorMessage() {
        StringBuilder sb = new StringBuilder("Aggregated incompatible results:\n");
        for (CompatibilityResult result : this.compatibilityResults) {
            sb.append(result.errorMessage()).append("\n");
        }
        return Optional.of(sb.toString());
    }

    @Override
    public Optional<Set<String>> incompatibleAttributes() {
        return Optional.of(this.compatibilityResults.stream().filter(r -> ProviderIncompatibleResult.class.isAssignableFrom(r.getClass())).map(ProviderIncompatibleResult.class::cast).flatMap(r -> r.incompatibleAttributes().orElse(Set.of()).stream()).collect(Collectors.toSet()));
    }
}

