/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.io;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchResult;
import org.ldaptive.io.SearchResultWriter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Dsmlv1Writer
implements SearchResultWriter {
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private final Writer dsmlWriter;
    private Map<String, String> outputProperties = new HashMap<String, String>();

    public Dsmlv1Writer(Writer writer) {
        this.dsmlWriter = writer;
        this.outputProperties.put("doctype-public", "yes");
        this.outputProperties.put("indent", "yes");
        this.outputProperties.put("{http://xml.apache.org/xslt}indent-amount", "2");
    }

    public Map<String, String> getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(Map<String, String> properties) {
        this.outputProperties = properties;
    }

    @Override
    public void write(SearchResult result) throws IOException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
            for (Map.Entry<String, String> prop : this.outputProperties.entrySet()) {
                transformer.setOutputProperty(prop.getKey(), prop.getValue());
            }
            StreamResult sr = new StreamResult(this.dsmlWriter);
            DOMSource source = new DOMSource(this.createDsml(result));
            transformer.transform(source, sr);
            this.dsmlWriter.flush();
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IOException(e);
        }
    }

    protected Document createDsml(SearchResult result) throws ParserConfigurationException {
        DocumentBuilder db = DOC_BUILDER_FACTORY.newDocumentBuilder();
        DOMImplementation domImpl = db.getDOMImplementation();
        Document doc = domImpl.createDocument("http://www.dsml.org/DSML", "dsml:dsml", null);
        doc.setXmlStandalone(true);
        Element entriesElement = doc.createElement("dsml:directory-entries");
        doc.getDocumentElement().appendChild(entriesElement);
        if (result != null) {
            for (LdapEntry le : result.getEntries()) {
                Element entryElement = doc.createElement("dsml:entry");
                if (le.getDn() != null) {
                    entryElement.setAttribute("dn", le.getDn());
                }
                this.createDsmlAttributes(doc, le.getAttributes()).forEach(entryElement::appendChild);
                entriesElement.appendChild(entryElement);
            }
        }
        return doc;
    }

    protected List<Element> createDsmlAttributes(Document doc, Collection<LdapAttribute> attrs) {
        ArrayList<Element> attrElements = new ArrayList<Element>();
        for (LdapAttribute attr : attrs) {
            Element attrElement;
            String attrName = attr.getName();
            if ("objectclass".equalsIgnoreCase(attrName)) {
                attrElement = this.createObjectclassElement(doc, attr);
                if (!attrElement.hasChildNodes()) continue;
                attrElements.add(0, attrElement);
                continue;
            }
            attrElement = this.createAttrElement(doc, attr);
            if (!attrElement.hasChildNodes()) continue;
            attrElements.add(attrElement);
        }
        return attrElements;
    }

    protected Element createAttrElement(Document doc, LdapAttribute attr) {
        Element attrElement = doc.createElement("dsml:attr");
        attrElement.setAttribute("name", attr.getName());
        for (String s : attr.getStringValues()) {
            Element valueElement = doc.createElement("dsml:value");
            attrElement.appendChild(valueElement);
            this.setAttrValue(doc, valueElement, s, attr.isBinary());
        }
        return attrElement;
    }

    protected Element createObjectclassElement(Document doc, LdapAttribute attr) {
        Element ocElement = doc.createElement("dsml:objectclass");
        for (String s : attr.getStringValues()) {
            Element ocValueElement = doc.createElement("dsml:oc-value");
            ocElement.appendChild(ocValueElement);
            this.setAttrValue(doc, ocValueElement, s, attr.isBinary());
        }
        return ocElement;
    }

    protected void setAttrValue(Document doc, Element valueElement, String value, boolean isBase64) {
        if (value != null) {
            valueElement.appendChild(doc.createTextNode(value));
            if (isBase64) {
                valueElement.setAttribute("encoding", "base64");
            }
        }
    }

    static {
        DOC_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

