/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.config;

import java.io.Serializable;

public final class ConfigScope
implements Serializable {
    public static final int DISABLED_ID = -1;
    public static final int INDIVIDUALLY_ID = 1;
    public static final int GLOBALLY_ID = Integer.MAX_VALUE;
    private static final String DISABLED_NAME = "disabled";
    private static final String INDIVIDUALLY_NAME = "individually";
    private static final String GLOBALLY_NAME = "globally";
    public static final ConfigScope DISABLED = new ConfigScope(-1, "disabled");
    public static final ConfigScope INDIVIDUALLY = new ConfigScope(1, "individually");
    public static final ConfigScope GLOBALLY = new ConfigScope(Integer.MAX_VALUE, "globally");
    private final int _value;
    private final String _name;

    private ConfigScope(int value, String name) {
        this._value = value;
        this._name = name;
    }

    public boolean applyConfig(boolean defaultValue) {
        switch (this._value) {
            case -1: {
                return false;
            }
            case 0x7FFFFFFF: {
                return true;
            }
        }
        return defaultValue;
    }

    public static ConfigScope forID(int id) {
        switch (id) {
            case -1: {
                return DISABLED;
            }
            case 1: {
                return INDIVIDUALLY;
            }
        }
        return GLOBALLY;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigScope tb = (ConfigScope)obj;
        return this._value == tb._value;
    }

    public int hashCode() {
        return this._value;
    }

    private Object readResolve() {
        switch (this._value) {
            case -1: {
                return DISABLED;
            }
            case 1: {
                return INDIVIDUALLY;
            }
        }
        return GLOBALLY;
    }

    public String toString() {
        return this._name;
    }
}

