/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import java.io.Serializable;

public final class TernaryBool
implements Serializable {
    private static final int NO_ID = -1;
    private static final int YES_ID = 1;
    private static final int UNSPECIFIED_ID = 0;
    public static final TernaryBool NO = new TernaryBool(-1);
    public static final TernaryBool YES = new TernaryBool(1);
    public static final TernaryBool UNSPECIFIED = new TernaryBool(0);
    private final int _value;

    private TernaryBool(int value) {
        this._value = value;
    }

    public boolean booleanValue(boolean defaultValue) {
        switch (this._value) {
            case -1: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return defaultValue;
    }

    public boolean isUnspecified() {
        return this == UNSPECIFIED;
    }

    public boolean definiteYes() {
        return this == YES;
    }

    public boolean definiteNo() {
        return this == NO;
    }

    public static TernaryBool forBoolean(boolean value) {
        return value ? YES : NO;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TernaryBool tb = (TernaryBool)obj;
        return this._value == tb._value;
    }

    public int hashCode() {
        return this._value;
    }

    private Object readResolve() {
        switch (this._value) {
            case -1: {
                return NO;
            }
            case 1: {
                return YES;
            }
        }
        return UNSPECIFIED;
    }

    public String toString() {
        switch (this._value) {
            case -1: {
                return "NO";
            }
            case 1: {
                return "YES";
            }
        }
        return "UNSPECIFIED";
    }
}

