/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectMethod;

public final class EventDispatcher {
    private static final String[] events = new String[]{"objectCanDelete", "objectOnDelete", "objectOnActivate", "objectOnDeactivate", "objectOnNew", "objectOnUpdate", "objectCanActivate", "objectCanDeactivate", "objectCanNew", "objectCanUpdate"};
    static final int CAN_DELETE = 0;
    static final int DELETE = 1;
    static final int SERVER_COUNT = 2;
    static final int ACTIVATE = 2;
    static final int DEACTIVATE = 3;
    static final int NEW = 4;
    public static final int UPDATE = 5;
    static final int CAN_ACTIVATE = 6;
    static final int CAN_DEACTIVATE = 7;
    static final int CAN_NEW = 8;
    static final int CAN_UPDATE = 9;
    static final int COUNT = 10;
    private final ReflectMethod[] methods;

    private EventDispatcher(ReflectMethod[] methods_) {
        this.methods = methods_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dispatch(Transaction trans, Object obj, int eventID) {
        if (this.methods[eventID] == null) {
            return true;
        }
        Object[] parameters = new Object[]{trans.objectContainer()};
        ObjectContainerBase container = trans.container();
        int stackDepth = container.stackDepth();
        int topLevelCallId = container.topLevelCallId();
        container.stackDepth(0);
        try {
            Object res = this.methods[eventID].invoke(obj, parameters);
            if (res instanceof Boolean) {
                boolean bl = (Boolean)res;
                return bl;
            }
        }
        finally {
            container.stackDepth(stackDepth);
            container.topLevelCallId(topLevelCallId);
        }
        return true;
    }

    static EventDispatcher forClass(ObjectContainerBase a_stream, ReflectClass classReflector) {
        if (a_stream == null || classReflector == null) {
            return null;
        }
        EventDispatcher dispatcher = null;
        int count = 0;
        if (a_stream.configImpl().callbacks()) {
            count = 10;
        } else if (a_stream.configImpl().isServer()) {
            count = 2;
        }
        if (count > 0) {
            ReflectClass[] parameterClasses = new ReflectClass[]{a_stream._handlers.ICLASS_OBJECTCONTAINER};
            ReflectMethod[] methods = new ReflectMethod[10];
            for (int i = 9; i >= 0; --i) {
                ReflectMethod method = classReflector.getMethod(events[i], parameterClasses);
                if (null == method) {
                    method = classReflector.getMethod(EventDispatcher.toPascalCase(events[i]), parameterClasses);
                }
                if (method == null) continue;
                methods[i] = method;
                if (dispatcher != null) continue;
                dispatcher = new EventDispatcher(methods);
            }
        }
        return dispatcher;
    }

    private static String toPascalCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public boolean hasEventRegistered(int eventID) {
        return this.methods[eventID] != null;
    }
}

