/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Readable;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeReader;

public class LockedTree {
    private Tree _tree;
    private int _version;

    public void add(Tree tree) {
        this.changed();
        this._tree = this._tree == null ? tree : this._tree.add(tree);
    }

    private void changed() {
        ++this._version;
    }

    public void clear() {
        this.changed();
        this._tree = null;
    }

    public Tree find(int key) {
        return TreeInt.find(this._tree, key);
    }

    public void read(ByteArrayBuffer buffer, Readable template) {
        this.clear();
        this._tree = new TreeReader(buffer, template).read();
        this.changed();
    }

    public void traverseLocked(Visitor4 visitor) {
        int currentVersion = this._version;
        Tree.traverse(this._tree, visitor);
        if (this._version != currentVersion) {
            throw new IllegalStateException();
        }
    }

    public void traverseMutable(Visitor4 visitor) {
        final Collection4 currentContent = new Collection4();
        this.traverseLocked(new Visitor4(){

            @Override
            public void visit(Object obj) {
                currentContent.add(obj);
            }
        });
        Iterator4 i = currentContent.iterator();
        while (i.moveNext()) {
            visitor.visit(i.current());
        }
    }
}

