/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepth;

public class ActivationContext4 {
    private final Transaction _transaction;
    private final Object _targetObject;
    private final ActivationDepth _depth;

    public ActivationContext4(Transaction transaction, Object obj, ActivationDepth depth) {
        this._transaction = transaction;
        this._targetObject = obj;
        this._depth = depth;
    }

    public void cascadeActivationToTarget(ClassMetadata classMetadata, boolean doDescend) {
        ActivationDepth depth = doDescend ? this._depth.descend(classMetadata) : this._depth;
        this.cascadeActivation(classMetadata, this.targetObject(), depth);
    }

    public void cascadeActivationToChild(Object obj) {
        if (obj == null) {
            return;
        }
        ClassMetadata classMetadata = this.container().classMetadataForObject(obj);
        if (classMetadata == null || classMetadata.isPrimitive()) {
            return;
        }
        ActivationDepth depth = this._depth.descend(classMetadata);
        this.cascadeActivation(classMetadata, obj, depth);
    }

    private void cascadeActivation(ClassMetadata classMetadata, Object obj, ActivationDepth depth) {
        if (!depth.requiresActivation()) {
            return;
        }
        if (depth.mode().isDeactivate()) {
            this.container().stillToDeactivate(this._transaction, obj, depth, false);
        } else if (classMetadata.isValueType()) {
            classMetadata.activateFields(this._transaction, obj, depth);
        } else {
            this.container().stillToActivate(this._transaction, obj, depth);
        }
    }

    public ObjectContainerBase container() {
        return this._transaction.container();
    }

    public Object targetObject() {
        return this._targetObject;
    }
}

