/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.freespace.BTreeFreespaceManager;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.freespace.FreespaceManagerIx;
import com.db4o.internal.freespace.RamFreespaceManager;
import com.db4o.internal.slots.Slot;

public abstract class AbstractFreespaceManager
implements FreespaceManager {
    final LocalObjectContainer _file;
    public static final byte FM_DEBUG = 127;
    public static final byte FM_DEFAULT = 0;
    public static final byte FM_LEGACY_RAM = 1;
    public static final byte FM_RAM = 2;
    public static final byte FM_IX = 3;
    public static final byte FM_BTREE = 4;
    private static final int INTS_IN_SLOT = 12;

    public AbstractFreespaceManager(LocalObjectContainer file) {
        this._file = file;
    }

    public static byte checkType(byte systemType) {
        if (systemType == 0) {
            return 2;
        }
        return systemType;
    }

    public static AbstractFreespaceManager createNew(LocalObjectContainer file) {
        return AbstractFreespaceManager.createNew(file, file.systemData().freespaceSystem());
    }

    public static AbstractFreespaceManager createNew(LocalObjectContainer file, byte systemType) {
        systemType = AbstractFreespaceManager.checkType(systemType);
        switch (systemType) {
            case 3: {
                return new FreespaceManagerIx(file);
            }
            case 4: {
                return new BTreeFreespaceManager(file);
            }
        }
        return new RamFreespaceManager(file);
    }

    public static int initSlot(LocalObjectContainer file) {
        int address = file.getSlot(AbstractFreespaceManager.slotLength()).address();
        AbstractFreespaceManager.slotEntryToZeroes(file, address);
        return address;
    }

    @Override
    public void migrateTo(final FreespaceManager fm) {
        this.traverse(new Visitor4(){

            @Override
            public void visit(Object obj) {
                fm.free((Slot)obj);
            }
        });
    }

    static void slotEntryToZeroes(LocalObjectContainer file, int address) {
        StatefulBuffer writer = new StatefulBuffer(file.systemTransaction(), address, AbstractFreespaceManager.slotLength());
        for (int i = 0; i < 12; ++i) {
            writer.writeInt(0);
        }
        writer.writeEncrypt();
    }

    static final int slotLength() {
        return 48;
    }

    @Override
    public int totalFreespace() {
        final IntByRef mint = new IntByRef();
        this.traverse(new Visitor4(){

            @Override
            public void visit(Object obj) {
                Slot slot = (Slot)obj;
                mint.value += slot.length();
            }
        });
        return mint.value;
    }

    @Override
    public abstract void beginCommit();

    protected final int blockedDiscardLimit() {
        return this._file.blocksToBytes(this.discardLimit());
    }

    protected int discardLimit() {
        return this._file.configImpl().discardFreeSpace();
    }

    final boolean canDiscard(int blocks) {
        return blocks == 0 || blocks < this.blockedDiscardLimit();
    }

    public static void migrate(FreespaceManager oldFM, FreespaceManager newFM) {
        oldFM.migrateTo(newFM);
        oldFM.freeSelf();
    }

    public void debugCheckIntegrity() {
        final IntByRef lastStart = new IntByRef();
        final IntByRef lastEnd = new IntByRef();
        this.traverse(new Visitor4(){

            @Override
            public void visit(Object obj) {
                Slot slot = (Slot)obj;
                if (slot.address() <= lastEnd.value) {
                    throw new IllegalStateException();
                }
                lastStart.value = slot.address();
                lastEnd.value = slot.address() + slot.length();
            }
        });
    }

    protected final LocalTransaction transaction() {
        return (LocalTransaction)this._file.systemTransaction();
    }

    public static boolean migrationRequired(byte systemType) {
        return systemType == 1 || systemType == 3;
    }
}

