/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers.net;

import com.db4o.internal.handlers.net.NetSimpleTypeHandler;
import com.db4o.reflect.Reflector;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NetDecimal
extends NetSimpleTypeHandler {
    private static final BigInteger BYTESHIFT_FACTOR = new BigInteger("100", 16);
    private static final BigInteger ZERO = new BigInteger("0", 16);
    private static final BigDecimal TEN = new BigDecimal("10");

    public NetDecimal(Reflector reflector) {
        super(reflector, 21, 16);
    }

    @Override
    public String toString(byte[] bytes) {
        BigInteger mantissa = ZERO;
        for (int blockoffset = 8; blockoffset >= 0; blockoffset -= 4) {
            for (int byteidx = 0; byteidx < 4; ++byteidx) {
                mantissa = mantissa.multiply(BYTESHIFT_FACTOR);
                int idx = blockoffset + byteidx;
                mantissa = mantissa.add(new BigInteger(String.valueOf(bytes[idx] & 0xFF), 10));
            }
        }
        int exponent = -bytes[13] & 0x1F;
        boolean negative = bytes[12] != 0;
        BigDecimal result = new BigDecimal(mantissa);
        if (exponent < 0) {
            for (int i = exponent; i < 0; ++i) {
                result = result.divide(TEN, 5);
            }
        } else {
            for (int i = 0; i < exponent; ++i) {
                result = result.multiply(TEN);
            }
        }
        if (negative) {
            result = result.negate();
        }
        return result.toString();
    }
}

