/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import SevenZip.Compression.LZMA.Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.contrapunctus.lzma.ConcurrentBufferOutputStream;
import net.contrapunctus.lzma.EncoderThread;

public class LzmaOutputStream
extends FilterOutputStream {
    protected EncoderThread eth;
    public static boolean LZMA_HEADER = true;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    public LzmaOutputStream(OutputStream outputStream) {
        this(outputStream, EncoderThread.DEFAULT_DICT_SZ_POW2, null);
    }

    public LzmaOutputStream(OutputStream outputStream, Integer n, Integer n2) {
        super(null);
        this.eth = new EncoderThread(outputStream, n, n2);
        this.out = ConcurrentBufferOutputStream.create(this.eth.q);
        if (DEBUG) {
            dbg.printf("%s >> %s (%s)%n", this, this.out, this.eth.q);
        }
        this.eth.start();
    }

    @Override
    public void write(int n) throws IOException {
        if (this.eth.exn != null) {
            throw this.eth.exn;
        }
        this.out.write(n);
    }

    @Override
    public void close() throws IOException {
        if (DEBUG) {
            dbg.printf("%s closed%n", this);
        }
        this.out.close();
        try {
            this.eth.join();
            if (DEBUG) {
                dbg.printf("%s joined %s%n", this, this.eth);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        if (this.eth.exn != null) {
            throw this.eth.exn;
        }
    }

    public String toString() {
        return String.format("lzmaOut@%x", this.hashCode());
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "Hello hello hello, world!";
        String string2 = "This is the best test.";
        OutputStream outputStream = new OutputStream(){

            @Override
            public void write(int n) {
                System.out.printf("%02x ", n);
            }
        };
        LzmaOutputStream lzmaOutputStream = new LzmaOutputStream(outputStream);
        PrintStream printStream = new PrintStream(lzmaOutputStream);
        printStream.print(string);
        printStream.print(string2);
        printStream.close();
        System.out.println();
        System.out.println("TRADITIONAL WAY:");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(string);
        printStream.print(string2);
        printStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayOutputStream = new ByteArrayOutputStream();
        Encoder encoder = new Encoder();
        encoder.SetEndMarkerMode(true);
        encoder.SetDictionarySize(0x100000);
        encoder.WriteCoderProperties(byteArrayOutputStream);
        encoder.Code(byteArrayInputStream, byteArrayOutputStream, -1L, -1L, null);
        byArray = byteArrayOutputStream.toByteArray();
        for (int i = 0; i < byArray.length; ++i) {
            System.out.printf("%02x ", byArray[i]);
        }
        System.out.println();
    }

    static {
        String string = null;
        try {
            string = System.getProperty("DEBUG_LzmaStreams");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = string != null;
    }
}

