/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.quadrature.vectorial;

import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.SampledFunctionIterator;
import org.spaceroots.mantissa.functions.vectorial.VectorialValuedPair;

public class EnhancedSimpsonIntegratorSampler
implements SampledFunctionIterator {
    private SampledFunctionIterator iter;
    private VectorialValuedPair next;
    private double[] sum;

    public EnhancedSimpsonIntegratorSampler(SampledFunctionIterator iter) throws ExhaustedSampleException, FunctionException {
        this.iter = iter;
        this.next = iter.nextSamplePoint();
        this.sum = new double[iter.getDimension()];
        for (int i = 0; i < this.sum.length; ++i) {
            this.sum[i] = 0.0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public int getDimension() {
        return this.iter.getDimension();
    }

    @Override
    public VectorialValuedPair nextSamplePoint() throws ExhaustedSampleException, FunctionException {
        VectorialValuedPair previous = this.next;
        VectorialValuedPair current = this.iter.nextSamplePoint();
        try {
            this.next = this.iter.nextSamplePoint();
            double h1 = current.x - previous.x;
            double h2 = this.next.x - current.x;
            double cP = (h1 + h2) * (2.0 * h1 - h2) / (6.0 * h1);
            double cC = (h1 + h2) * (h1 + h2) * (h1 + h2) / (6.0 * h1 * h2);
            double cN = (h1 + h2) * (2.0 * h2 - h1) / (6.0 * h2);
            double[] pY = previous.y;
            double[] cY = current.y;
            double[] nY = this.next.y;
            for (int i = 0; i < this.sum.length; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + (cP * pY[i] + cC * cY[i] + cN * nY[i]);
            }
        }
        catch (ExhaustedSampleException e) {
            double halfDx = 0.5 * (current.x - previous.x);
            double[] pY = previous.y;
            double[] cY = current.y;
            for (int i = 0; i < this.sum.length; ++i) {
                int n = i;
                this.sum[n] = this.sum[n] + halfDx * (pY[i] + cY[i]);
            }
            return new VectorialValuedPair(current.x, this.sum);
        }
        return new VectorialValuedPair(this.next.x, (double[])this.sum.clone());
    }
}

