/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.quadrature.vectorial;

import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.SampledFunctionIterator;
import org.spaceroots.mantissa.functions.vectorial.VectorialValuedPair;

public class TrapezoidIntegratorSampler
implements SampledFunctionIterator {
    private SampledFunctionIterator iter;
    private VectorialValuedPair current;
    private double[] sum;

    public TrapezoidIntegratorSampler(SampledFunctionIterator iter) throws ExhaustedSampleException, FunctionException {
        this.iter = iter;
        this.current = iter.nextSamplePoint();
        this.sum = new double[iter.getDimension()];
        for (int i = 0; i < this.sum.length; ++i) {
            this.sum[i] = 0.0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public int getDimension() {
        return this.iter.getDimension();
    }

    @Override
    public VectorialValuedPair nextSamplePoint() throws ExhaustedSampleException, FunctionException {
        VectorialValuedPair previous = this.current;
        this.current = this.iter.nextSamplePoint();
        double halfDx = 0.5 * (this.current.x - previous.x);
        double[] pY = previous.y;
        double[] cY = this.current.y;
        for (int i = 0; i < this.sum.length; ++i) {
            int n = i;
            this.sum[n] = this.sum[n] + halfDx * (pY[i] + cY[i]);
        }
        return new VectorialValuedPair(this.current.x, (double[])this.sum.clone());
    }
}

