/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.FetchWaiter;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.MetadataUnresolvedException;
import freenet.client.NullClientCallback;
import freenet.client.PutWaiter;
import freenet.client.async.BaseManifestPutter;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutter;
import freenet.client.async.DefaultManifestPutter;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.TooManyFilesInsertException;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.EventLogger;
import freenet.client.events.SimpleEventProducer;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.io.NullBucket;
import freenet.support.io.PersistentFileTracker;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

public class HighLevelSimpleClientImpl
implements HighLevelSimpleClient,
RequestClient,
Cloneable {
    private final short priorityClass;
    private final BucketFactory bucketFactory;
    private final BucketFactory persistentBucketFactory;
    private final PersistentFileTracker persistentFileTracker;
    private final NodeClientCore core;
    private final ClientEventProducer eventProducer;
    private long curMaxLength;
    private long curMaxTempLength;
    private int curMaxMetadataLength;
    private final RandomSource random;
    private final boolean realTimeFlag;
    static final int MAX_RECURSION = 10;
    static final int MAX_ARCHIVE_RESTARTS = 2;
    static final int MAX_ARCHIVE_LEVELS = 10;
    static final boolean DONT_ENTER_IMPLICIT_ARCHIVES = true;
    static final int SPLITFILE_BLOCK_RETRIES = Math.min(3, 2);
    static final int NON_SPLITFILE_RETRIES = Math.min(3, 2);
    static final int USK_RETRIES = 2;
    static final boolean FETCH_SPLITFILES = true;
    static final boolean FOLLOW_REDIRECTS = true;
    static final boolean LOCAL_REQUESTS_ONLY = false;
    static final boolean CAN_WRITE_CLIENT_CACHE = true;
    static final boolean CAN_WRITE_CLIENT_CACHE_INSERTS = false;
    static final int INSERT_RETRIES = 10;
    static final int CONSECUTIVE_RNFS_ASSUME_SUCCESS = 2;
    static final int MAX_SPLITFILE_BLOCKS_PER_SEGMENT = 256;
    static final int MAX_SPLITFILE_CHECK_BLOCKS_PER_SEGMENT = 256;
    public static final int SPLITFILE_SCALING_BLOCKS_PER_SEGMENT = 128;
    public static final int SPLITFILE_BLOCKS_PER_SEGMENT = 136;
    public static final int SPLITFILE_CHECK_BLOCKS_PER_SEGMENT = 128;
    public static final int EXTRA_INSERTS_SINGLE_BLOCK = 2;
    public static final int EXTRA_INSERTS_SPLITFILE_HEADER = 2;
    static final boolean FILTER_DATA = false;
    private final ClientGetCallback nullCallback = new NullClientCallback(this);

    public HighLevelSimpleClientImpl(NodeClientCore node, BucketFactory bf, RandomSource r, short priorityClass, boolean forceDontIgnoreTooManyPathComponents, boolean realTimeFlag) {
        this.core = node;
        this.priorityClass = priorityClass;
        this.bucketFactory = bf;
        this.persistentFileTracker = node.persistentTempBucketFactory;
        this.random = r;
        this.eventProducer = new SimpleEventProducer();
        this.eventProducer.addEventListener(new EventLogger(Logger.LogLevel.MINOR, false));
        this.curMaxLength = Long.MAX_VALUE;
        this.curMaxTempLength = Long.MAX_VALUE;
        this.curMaxMetadataLength = 0x100000;
        this.persistentBucketFactory = node.persistentTempBucketFactory;
        this.realTimeFlag = realTimeFlag;
    }

    public HighLevelSimpleClientImpl(HighLevelSimpleClientImpl hlsc) {
        this.eventProducer = new SimpleEventProducer();
        this.priorityClass = hlsc.priorityClass;
        this.bucketFactory = hlsc.bucketFactory;
        this.persistentBucketFactory = hlsc.persistentBucketFactory;
        this.persistentFileTracker = hlsc.persistentFileTracker;
        this.core = hlsc.core;
        this.curMaxLength = hlsc.curMaxLength;
        this.curMaxMetadataLength = hlsc.curMaxMetadataLength;
        this.curMaxTempLength = hlsc.curMaxTempLength;
        this.random = hlsc.random;
        this.realTimeFlag = hlsc.realTimeFlag;
    }

    @Override
    public HighLevelSimpleClientImpl clone() {
        return new HighLevelSimpleClientImpl(this);
    }

    @Override
    public void setMaxLength(long maxLength) {
        this.curMaxLength = maxLength;
    }

    @Override
    public void setMaxIntermediateLength(long maxIntermediateLength) {
        this.curMaxTempLength = maxIntermediateLength;
    }

    @Override
    public FetchResult fetch(FreenetURI uri) throws FetchException {
        if (uri == null) {
            throw new NullPointerException();
        }
        FetchContext context = this.getFetchContext();
        FetchWaiter fw = new FetchWaiter(this);
        ClientGetter get = new ClientGetter(fw, uri, context, this.priorityClass, null, null, null);
        try {
            this.core.clientContext.start(get);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return fw.waitForCompletion();
    }

    @Override
    public FetchResult fetchFromMetadata(Bucket initialMetadata) throws FetchException {
        if (initialMetadata == null) {
            throw new NullPointerException();
        }
        FetchContext context = this.getFetchContext();
        FetchWaiter fw = new FetchWaiter(this);
        ClientGetter get = new ClientGetter(fw, FreenetURI.EMPTY_CHK_URI, context, this.priorityClass, null, null, initialMetadata);
        try {
            this.core.clientContext.start(get);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return fw.waitForCompletion();
    }

    @Override
    public FetchResult fetch(FreenetURI uri, long overrideMaxSize) throws FetchException {
        return this.fetch(uri, overrideMaxSize, this);
    }

    @Override
    public FetchResult fetch(FreenetURI uri, long overrideMaxSize, RequestClient clientContext) throws FetchException {
        if (uri == null) {
            throw new NullPointerException();
        }
        FetchWaiter fw = new FetchWaiter(clientContext);
        FetchContext context = this.getFetchContext(overrideMaxSize);
        ClientGetter get = new ClientGetter(fw, uri, context, this.priorityClass, null, null, null);
        try {
            this.core.clientContext.start(get);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return fw.waitForCompletion();
    }

    @Override
    public ClientGetter fetch(FreenetURI uri, long maxSize, ClientGetCallback callback, FetchContext fctx) throws FetchException {
        return this.fetch(uri, maxSize, callback, fctx, this.priorityClass);
    }

    @Override
    public ClientGetter fetch(FreenetURI uri, long maxSize, ClientGetCallback callback, FetchContext fctx, short prio) throws FetchException {
        return this.fetch(uri, callback, fctx, prio);
    }

    @Override
    public ClientGetter fetch(FreenetURI uri, ClientGetCallback callback, FetchContext fctx, short prio) throws FetchException {
        if (uri == null) {
            throw new NullPointerException();
        }
        ClientGetter get = new ClientGetter(callback, uri, fctx, prio, null, null, null);
        try {
            this.core.clientContext.start(get);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return get;
    }

    @Override
    public ClientGetter fetchFromMetadata(Bucket initialMetadata, ClientGetCallback callback, FetchContext fctx, short prio) throws FetchException {
        if (initialMetadata == null) {
            throw new NullPointerException();
        }
        ClientGetter get = new ClientGetter(callback, FreenetURI.EMPTY_CHK_URI, fctx, prio, null, null, initialMetadata);
        try {
            this.core.clientContext.start(get);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return get;
    }

    @Override
    public FreenetURI insert(InsertBlock insert, boolean getCHKOnly, String filenameHint) throws InsertException {
        return this.insert(insert, getCHKOnly, filenameHint, this.priorityClass);
    }

    @Override
    public FreenetURI insert(InsertBlock insert, boolean getCHKOnly, String filenameHint, short priority) throws InsertException {
        return this.insert(insert, getCHKOnly, filenameHint, false, priority);
    }

    public FreenetURI insert(InsertBlock insert, boolean getCHKOnly, String filenameHint, boolean isMetadata, short priority) throws InsertException {
        InsertContext context = this.getInsertContext(true);
        context.getCHKOnly = getCHKOnly;
        return this.insert(insert, filenameHint, isMetadata, priority, context);
    }

    @Override
    public FreenetURI insert(InsertBlock insert, String filenameHint, short priority, InsertContext ctx) throws InsertException {
        return this.insert(insert, filenameHint, false, priority, ctx);
    }

    public FreenetURI insert(InsertBlock insert, String filenameHint, boolean isMetadata, short priority, InsertContext ctx) throws InsertException {
        return this.insert(insert, filenameHint, isMetadata, priority, ctx, null);
    }

    public FreenetURI insert(InsertBlock insert, String filenameHint, boolean isMetadata, short priority, InsertContext ctx, byte[] forceCryptoKey) throws InsertException {
        PutWaiter pw = new PutWaiter(this);
        ClientPutter put = new ClientPutter(pw, insert.getData(), insert.desiredURI, insert.clientMetadata, ctx, priority, isMetadata, filenameHint, false, this.core.clientContext, forceCryptoKey, -1L);
        try {
            this.core.clientContext.start(put);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return pw.waitForCompletion();
    }

    @Override
    public ClientPutter insert(InsertBlock insert, String filenameHint, boolean isMetadata, InsertContext ctx, ClientPutCallback cb) throws InsertException {
        return this.insert(insert, filenameHint, isMetadata, ctx, cb, this.priorityClass);
    }

    @Override
    public ClientPutter insert(InsertBlock insert, String filenameHint, boolean isMetadata, InsertContext ctx, ClientPutCallback cb, short priority) throws InsertException {
        ClientPutter put = new ClientPutter(cb, insert.getData(), insert.desiredURI, insert.clientMetadata, ctx, priority, isMetadata, filenameHint, false, this.core.clientContext, null, -1L);
        try {
            this.core.clientContext.start(put);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return put;
    }

    @Override
    public FreenetURI insertRedirect(FreenetURI insertURI, FreenetURI targetURI) throws InsertException {
        RandomAccessBucket b;
        Metadata m = new Metadata(Metadata.DocumentType.SIMPLE_REDIRECT, null, null, targetURI, new ClientMetadata());
        try {
            b = m.toBucket(this.bucketFactory);
        }
        catch (IOException e) {
            Logger.error(this, "Bucket error: " + e, (Throwable)e);
            throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null);
        }
        catch (MetadataUnresolvedException e) {
            Logger.error(this, "Impossible error: " + e, (Throwable)e);
            throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, e, null);
        }
        InsertBlock block = new InsertBlock(b, null, insertURI);
        FreenetURI uri = this.insert(block, false, null, true, this.priorityClass);
        block.free();
        return uri;
    }

    @Override
    public FreenetURI insertManifest(FreenetURI insertURI, HashMap<String, Object> bucketsByName, String defaultName) throws InsertException {
        return this.insertManifest(insertURI, bucketsByName, defaultName, this.priorityClass);
    }

    @Override
    public FreenetURI insertManifest(FreenetURI insertURI, HashMap<String, Object> bucketsByName, String defaultName, short priorityClass) throws InsertException {
        return this.insertManifest(insertURI, bucketsByName, defaultName, priorityClass, null);
    }

    @Override
    public FreenetURI insertManifest(FreenetURI insertURI, HashMap<String, Object> bucketsByName, String defaultName, short priorityClass, byte[] forceCryptoKey) throws InsertException {
        DefaultManifestPutter putter;
        PutWaiter pw = new PutWaiter(this);
        try {
            putter = new DefaultManifestPutter(pw, BaseManifestPutter.bucketsByNameToManifestEntries(bucketsByName), priorityClass, insertURI, defaultName, this.getInsertContext(true), false, forceCryptoKey, this.core.clientContext);
        }
        catch (TooManyFilesInsertException e1) {
            throw new InsertException(InsertException.InsertExceptionMode.TOO_MANY_FILES);
        }
        try {
            this.core.clientContext.start(putter);
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
        return pw.waitForCompletion();
    }

    @Override
    public void addEventHook(ClientEventListener listener) {
        this.eventProducer.addEventListener(listener);
    }

    @Override
    public FetchContext getFetchContext() {
        return this.getFetchContext(-1L);
    }

    @Override
    public FetchContext getFetchContext(long overrideMaxSize) {
        long maxLength = this.curMaxLength;
        long maxTempLength = this.curMaxTempLength;
        if (overrideMaxSize >= 0L) {
            maxLength = overrideMaxSize;
            maxTempLength = overrideMaxSize;
        }
        return new FetchContext(maxLength, maxTempLength, this.curMaxMetadataLength, 10, 2, 10, true, SPLITFILE_BLOCK_RETRIES, NON_SPLITFILE_RETRIES, 2, true, true, false, false, 256, 256, this.bucketFactory, this.eventProducer, false, true, null, null);
    }

    public static FetchContext makeDefaultFetchContext(long maxLength, long maxTempLength, BucketFactory bucketFactory, SimpleEventProducer eventProducer) {
        return new FetchContext(maxLength, maxTempLength, 0x100000, 10, 2, 10, true, SPLITFILE_BLOCK_RETRIES, NON_SPLITFILE_RETRIES, 2, true, true, false, false, 256, 256, bucketFactory, eventProducer, false, true, null, null);
    }

    @Override
    public InsertContext getInsertContext(boolean forceNonPersistent) {
        return new InsertContext(10, 2, 136, 128, this.eventProducer, false, true, false, Compressor.DEFAULT_COMPRESSORDESCRIPTOR, 2, 2, InsertContext.CompatibilityMode.COMPAT_DEFAULT);
    }

    public static InsertContext makeDefaultInsertContext(BucketFactory bucketFactory, SimpleEventProducer eventProducer) {
        return new InsertContext(10, 2, 136, 128, eventProducer, false, true, false, Compressor.DEFAULT_COMPRESSORDESCRIPTOR, 2, 2, InsertContext.CompatibilityMode.COMPAT_DEFAULT);
    }

    @Override
    public FreenetURI[] generateKeyPair(String docName) {
        InsertableClientSSK key = InsertableClientSSK.createRandom(this.random, docName);
        return new FreenetURI[]{key.getInsertURI(), key.getURI()};
    }

    @Override
    public void prefetch(FreenetURI uri, long timeout, long maxSize, Set<String> allowedTypes) {
        this.prefetch(uri, timeout, maxSize, allowedTypes, (short)5);
    }

    @Override
    public void prefetch(FreenetURI uri, long timeout, long maxSize, Set<String> allowedTypes, short prio) {
        FetchContext ctx = this.getFetchContext(maxSize);
        ctx.allowedMIMETypes = allowedTypes;
        final ClientGetter get = new ClientGetter(this.nullCallback, uri, ctx, prio, new NullBucket(), null, null);
        this.core.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                get.cancel(((HighLevelSimpleClientImpl)HighLevelSimpleClientImpl.this).core.clientContext);
            }
        }, timeout);
        try {
            this.core.clientContext.start(get);
        }
        catch (FetchException fetchException) {
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean realTimeFlag() {
        return this.realTimeFlag;
    }
}

