/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.BinaryBlob;
import freenet.client.async.ClientContext;
import freenet.keys.ClientKeyBlock;
import freenet.keys.Key;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;

public final class BinaryBlobWriter {
    private static volatile boolean logMINOR;
    private final HashSet<Key> _binaryBlobKeysAddedAlready = new HashSet();
    private final BucketFactory _bf;
    private final ArrayList<Bucket> _buckets;
    private final Bucket _out;
    private final boolean _isSingleBucket;
    private boolean _started = false;
    private boolean _finalized = false;
    private transient DataOutputStream _stream_cache = null;

    public BinaryBlobWriter(BucketFactory bf) {
        this._buckets = new ArrayList();
        this._bf = bf;
        this._out = null;
        this._isSingleBucket = false;
    }

    public BinaryBlobWriter(Bucket out) {
        this._buckets = null;
        this._bf = null;
        assert (out != null);
        this._out = out;
        this._isSingleBucket = true;
    }

    private DataOutputStream getOutputStream() throws IOException, BinaryBlobAlreadyClosedException {
        if (this._finalized) {
            throw new BinaryBlobAlreadyClosedException("Already finalized (getting final data) on " + this);
        }
        if (this._stream_cache == null) {
            if (this._isSingleBucket) {
                this._stream_cache = new DataOutputStream(this._out.getOutputStream());
            } else {
                RandomAccessBucket newBucket = this._bf.makeBucket(-1L);
                this._buckets.add(newBucket);
                this._stream_cache = new DataOutputStream(newBucket.getOutputStream());
            }
        }
        if (!this._started) {
            BinaryBlob.writeBinaryBlobHeader(this._stream_cache);
            this._started = true;
        }
        return this._stream_cache;
    }

    public synchronized void addKey(ClientKeyBlock block, ClientContext context) throws IOException, BinaryBlobAlreadyClosedException {
        Key key = block.getKey();
        if (this._binaryBlobKeysAddedAlready.contains(key)) {
            return;
        }
        BinaryBlob.writeKey(this.getOutputStream(), block.getBlock(), key);
        this._binaryBlobKeysAddedAlready.add(key);
    }

    public void finalizeBucket() throws IOException, BinaryBlobAlreadyClosedException {
        if (this._finalized) {
            throw new BinaryBlobAlreadyClosedException("Already finalized (closing blob).");
        }
        this.finalizeBucket(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeBucket(boolean mark) throws IOException, BinaryBlobAlreadyClosedException {
        if (this._finalized) {
            throw new BinaryBlobAlreadyClosedException("Already finalized (closing blob - 2).");
        }
        if (logMINOR) {
            Logger.minor(this, "Finalizing binary blob " + this, (Throwable)new Exception("debug"));
        }
        if (!this._isSingleBucket) {
            if (!mark && this._buckets.size() == 1) {
                return;
            }
            RandomAccessBucket out = this._bf.makeBucket(-1L);
            this.getSnapshot(out, mark);
            int n = this._buckets.size();
            for (int i = 0; i < n; ++i) {
                this._buckets.get(i).free();
            }
            if (mark) {
                out.setReadOnly();
            }
            this._buckets.clear();
            this._buckets.add(0, out);
        } else if (mark) {
            try (DataOutputStream out = new DataOutputStream(this.getOutputStream());){
                BinaryBlob.writeEndBlob(out);
            }
        }
        if (mark) {
            this._finalized = true;
        }
    }

    public synchronized void getSnapshot(Bucket bucket) throws IOException, BinaryBlobAlreadyClosedException {
        if (this._buckets.isEmpty()) {
            return;
        }
        if (this._finalized) {
            BucketTools.copy(this._buckets.get(0), bucket);
            return;
        }
        this.getSnapshot(bucket, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSnapshot(Bucket bucket, boolean addEndmarker) throws IOException, BinaryBlobAlreadyClosedException {
        if (this._buckets.isEmpty()) {
            return;
        }
        if (this._finalized) {
            throw new BinaryBlobAlreadyClosedException("Already closed (getting final data snapshot)");
        }
        try (OutputStream out = bucket.getOutputStream();){
            int n = this._buckets.size();
            for (int i = 0; i < n; ++i) {
                BucketTools.copyTo(this._buckets.get(i), out, -1L);
            }
            if (addEndmarker) {
                DataOutputStream dout = new DataOutputStream(out);
                BinaryBlob.writeEndBlob(dout);
                dout.flush();
            }
        }
    }

    public synchronized Bucket getFinalBucket() {
        if (!this._finalized) {
            throw new IllegalStateException("Not finalized!");
        }
        if (this._isSingleBucket) {
            return this._out;
        }
        return this._buckets.get(0);
    }

    public boolean isFinalized() {
        return this._finalized;
    }

    static {
        Logger.registerClass(BinaryBlobWriter.class);
    }

    public static class BinaryBlobAlreadyClosedException
    extends Exception {
        private static final long serialVersionUID = -1L;

        public BinaryBlobAlreadyClosedException(String message) {
            super(message);
        }
    }
}

