/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.KeySalter;
import freenet.crypt.RandomSource;
import freenet.crypt.SHA256;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.SendableGet;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

class KeyListenerTracker
implements KeySalter {
    private static volatile boolean logMINOR;
    private static final int MIN_RETRY_COUNT = 3;
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final boolean isRTScheduler;
    protected final ClientRequestScheduler sched;
    private final ArrayList<KeyListener> keyListeners;
    final boolean persistent;
    public byte[] globalSalt;

    public boolean persistent() {
        return this.persistent;
    }

    protected KeyListenerTracker(boolean forInserts, boolean forSSKs, boolean forRT, RandomSource random, ClientRequestScheduler sched, byte[] globalSalt, boolean persistent) {
        this.isInsertScheduler = forInserts;
        this.isSSKScheduler = forSSKs;
        this.isRTScheduler = forRT;
        this.sched = sched;
        this.keyListeners = new ArrayList();
        if (globalSalt == null) {
            globalSalt = new byte[32];
            random.nextBytes(globalSalt);
        }
        this.globalSalt = globalSalt;
        this.persistent = persistent;
    }

    protected static int fixRetryCount(int retryCount) {
        return Math.max(0, retryCount - 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingKeys(KeyListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            if (this.keyListeners.contains(listener)) {
                return;
            }
            this.keyListeners.add(listener);
        }
        if (logMINOR) {
            Logger.minor(this, "Added pending keys to " + this + " : size now " + this.keyListeners.size() + " : " + listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePendingKeys(KeyListener listener) {
        boolean ret;
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            ret = this.keyListeners.remove(listener);
        }
        listener.onRemove();
        if (logMINOR) {
            Logger.minor(this, "Removed pending keys from " + this + " : size now " + this.keyListeners.size() + " : " + listener, (Throwable)new Exception("debug"));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePendingKeys(HasKeyListener hasListener) {
        ArrayList<KeyListener> matches = new ArrayList<KeyListener>();
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            for (KeyListener listener : this.keyListeners) {
                HasKeyListener hkl;
                try {
                    hkl = listener.getHasKeyListener();
                }
                catch (Throwable t) {
                    Logger.error(this, String.format("Error in getHasKeyListener callback for %s", listener), t);
                    continue;
                }
                if (hkl != hasListener) continue;
                matches.add(listener);
            }
        }
        if (matches.isEmpty()) {
            return false;
        }
        for (KeyListener listener : matches) {
            try {
                this.removePendingKeys(listener);
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error while removing %s", listener), t);
            }
        }
        return true;
    }

    public short getKeyPrio(Key key, short priority, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        List<KeyListener> matches = this.probablyWantKey(key, saltedKey);
        if (matches.isEmpty()) {
            return priority;
        }
        for (KeyListener listener : matches) {
            short prio;
            try {
                prio = listener.definitelyWantKey(key, saltedKey, this.sched.clientContext);
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in definitelyWantKey callback for %s", listener), t);
                continue;
            }
            if (prio == -1 || prio >= priority) continue;
            priority = prio;
        }
        return priority;
    }

    public synchronized long countWaitingKeys() {
        long count = 0L;
        for (KeyListener listener : this.keyListeners) {
            try {
                count += listener.countKeys();
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in countKeys callback for %s", listener), t);
            }
        }
        return count;
    }

    public boolean anyWantKey(Key key, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        List<KeyListener> matches = this.probablyWantKey(key, saltedKey);
        if (!matches.isEmpty()) {
            for (KeyListener listener : matches) {
                try {
                    if (listener.definitelyWantKey(key, saltedKey, this.sched.clientContext) < 0) continue;
                    return true;
                }
                catch (Throwable t) {
                    Logger.error(this, String.format("Error in definitelyWantKey callback for %s", listener), t);
                }
            }
        }
        return false;
    }

    public synchronized boolean anyProbablyWantKey(Key key, ClientContext context) {
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        for (KeyListener listener : this.keyListeners) {
            try {
                if (!listener.probablyWantKey(key, saltedKey)) continue;
                return true;
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in probablyWantKey callback for %s", listener), t);
            }
        }
        return false;
    }

    public boolean tripPendingKey(Key key, KeyBlock block, ClientContext context) {
        if (key instanceof NodeSSK != this.isSSKScheduler) {
            Logger.error(this, "Key " + key + " on scheduler ssk=" + this.isSSKScheduler, (Throwable)new Exception("debug"));
            return false;
        }
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        List<KeyListener> matches = this.probablyWantKey(key, saltedKey);
        boolean ret = false;
        for (KeyListener listener : matches) {
            try {
                if (listener.handleBlock(key, saltedKey, block, context)) {
                    ret = true;
                }
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in handleBlock callback for %s", listener), t);
            }
            if (!listener.isEmpty()) continue;
            try {
                this.removePendingKeys(listener);
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error while removing %s", listener), t);
            }
        }
        return ret;
    }

    public SendableGet[] requestsForKey(Key key, ClientContext context) {
        ArrayList<SendableGet> list = new ArrayList<SendableGet>();
        assert (key instanceof NodeSSK == this.isSSKScheduler);
        byte[] saltedKey = this.saltKey(key);
        List<KeyListener> matches = this.probablyWantKey(key, saltedKey);
        for (KeyListener listener : matches) {
            SendableGet[] reqs;
            try {
                reqs = listener.getRequestsForKey(key, saltedKey, context);
            }
            catch (Throwable t) {
                Logger.error(this, String.format("Error in getRequestsForKey callback for %s", listener), t);
                continue;
            }
            if (reqs == null) continue;
            for (SendableGet req : reqs) {
                list.add(req);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new SendableGet[list.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(':');
        if (this.isInsertScheduler) {
            sb.append("insert:");
        }
        if (this.isSSKScheduler) {
            sb.append("SSK");
        } else {
            sb.append("CHK");
        }
        return sb.toString();
    }

    @Override
    public byte[] saltKey(Key key) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(key.getRoutingKey());
        md.update(this.globalSalt);
        byte[] ret = md.digest();
        SHA256.returnMessageDigest(md);
        return ret;
    }

    protected void hintGlobalSalt(byte[] globalSalt2) {
        if (this.globalSalt == null) {
            this.globalSalt = globalSalt2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyListener> probablyWantKey(Key key, byte[] saltedKey) {
        ArrayList<KeyListener> matches = new ArrayList<KeyListener>();
        KeyListenerTracker keyListenerTracker = this;
        synchronized (keyListenerTracker) {
            for (KeyListener listener : this.keyListeners) {
                block7: {
                    try {
                        if (!listener.probablyWantKey(key, saltedKey)) {
                        }
                        break block7;
                    }
                    catch (Throwable t) {
                        Logger.error(this, String.format("Error in probablyWantKey callback for %s", listener), t);
                    }
                    continue;
                }
                matches.add(listener);
            }
        }
        return matches;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

