/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CommentException;
import freenet.client.filter.HTMLFilter;
import freenet.client.filter.TagReplacerCallback;
import freenet.client.filter.URIProcessor;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.updateableelements.ImageElement;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.support.HTMLEncoder;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

public class PushingTagReplacerCallback
implements TagReplacerCallback {
    private FProxyFetchTracker tracker;
    private long maxSize;
    private ToadletContext ctx;

    public PushingTagReplacerCallback(FProxyFetchTracker tracker, long maxSize, ToadletContext ctx) {
        this.tracker = tracker;
        this.maxSize = maxSize;
        this.ctx = ctx;
    }

    public static String getClientSideLocalizationScript() {
        StringBuilder l10nBuilder = new StringBuilder("var l10n={\n");
        boolean isNamePresentAtLeastOnce = false;
        for (String key : NodeL10n.getBase().getAllNamesWithPrefix("fproxy.push")) {
            l10nBuilder.append(key.substring("fproxy.push".length() + 1) + ": \"" + HTMLEncoder.encode(NodeL10n.getBase().getString(key)) + "\",\n");
            isNamePresentAtLeastOnce = true;
        }
        String l10n = isNamePresentAtLeastOnce ? l10nBuilder.substring(0, l10nBuilder.length() - 2) : l10nBuilder.toString();
        l10n = l10n.concat("\n};");
        return l10n;
    }

    @Override
    public String processTag(HTMLFilter.ParsedTag pt, URIProcessor uriProcessor) {
        if (this.ctx.getContainer().isFProxyJavascriptEnabled() && this.ctx.getContainer().isFProxyWebPushingEnabled()) {
            if (pt.element.toLowerCase().compareTo("img") == 0) {
                for (String attr : pt.unparsedAttrs) {
                    String src;
                    String name = attr.substring(0, attr.indexOf(61));
                    String value = attr.substring(attr.indexOf(61) + 2, attr.length() - 1);
                    if (name.compareTo("src") != 0) continue;
                    try {
                        src = uriProcessor.makeURIAbsolute(uriProcessor.processURI(value, null, false, false));
                    }
                    catch (CommentException ce) {
                        return null;
                    }
                    catch (URISyntaxException use) {
                        return null;
                    }
                    if (src.startsWith("/")) {
                        src = src.substring(1);
                    }
                    try {
                        return new ImageElement(this.tracker, new FreenetURI(src), this.maxSize, this.ctx, pt, true).generate();
                    }
                    catch (MalformedURLException mue) {
                        return null;
                    }
                }
            } else {
                if (pt.element.toLowerCase().compareTo("body") == 0 && pt.startSlash) {
                    return "".concat("".concat("<input id=\"requestId\" type=\"hidden\" value=\"" + this.ctx.getUniqueId() + "\" name=\"requestId\"/>")).concat("<script type=\"text/javascript\" language=\"javascript\">".concat(PushingTagReplacerCallback.getClientSideLocalizationScript()).concat("</script>")).concat("</body>");
                }
                if (pt.element.toLowerCase().compareTo("head") == 0) {
                    return "<head><script type=\"text/javascript\" language=\"javascript\" src=\"/static/freenetjs/freenetjs.nocache.js\"></script><noscript><style> .jsonly {display:none;}</style></noscript><link href=\"/static/reset.css\" rel=\"stylesheet\" type=\"text/css\" />";
                }
            }
        }
        return null;
    }
}

