/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.FetchResult;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;

public class DataFoundMessage
extends FCPMessage {
    final String identifier;
    final boolean global;
    final String mimeType;
    final long dataLength;
    final long startupTime;
    final long completionTime;

    public DataFoundMessage(FetchResult fr, String identifier, boolean global, long startupTime, long completionTime) {
        this.identifier = identifier;
        this.global = global;
        this.mimeType = fr.getMimeType();
        this.dataLength = fr.size();
        this.startupTime = startupTime;
        this.completionTime = completionTime;
    }

    public DataFoundMessage(long foundDataLength, String foundDataMimeType, String identifier, boolean global, long startupTime, long completionTime) {
        this.mimeType = foundDataMimeType;
        this.identifier = identifier;
        this.global = global;
        this.dataLength = foundDataLength;
        this.startupTime = startupTime;
        this.completionTime = completionTime;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.put("Global", this.global);
        fs.putSingle("Metadata.ContentType", this.mimeType);
        fs.put("DataLength", this.dataLength);
        fs.put("StartupTime", this.startupTime);
        fs.put("CompletionTime", this.completionTime);
        return fs;
    }

    @Override
    public String getName() {
        return "DataFound";
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "DataFound goes from server to client not the other way around", this.identifier, this.global);
    }
}

