/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.InsertContext;
import freenet.client.async.BaseManifestPutter;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.crypt.EncryptedRandomAccessBucket;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.support.HexUtil;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.ManifestElement;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.DelayedFreeBucket;
import freenet.support.io.DelayedFreeRandomAccessBucket;
import freenet.support.io.FileBucket;
import freenet.support.io.NullBucket;
import freenet.support.io.PaddedEphemerallyEncryptedBucket;
import freenet.support.io.PersistentTempFileBucket;
import freenet.support.io.TempBucketFactory;
import java.util.HashMap;

public class PersistentPutDir
extends FCPMessage {
    static final String name = "PersistentPutDir";
    final String identifier;
    final FreenetURI uri;
    final FreenetURI privateURI;
    final int verbosity;
    final short priorityClass;
    final ClientRequest.Persistence persistence;
    final boolean global;
    private final HashMap<String, Object> manifestElements;
    final String defaultName;
    final String token;
    final boolean started;
    final int maxRetries;
    final boolean wasDiskPut;
    private final SimpleFieldSet cached;
    final boolean dontCompress;
    final String compressorDescriptor;
    final boolean realTime;
    final byte[] splitfileCryptoKey;
    final InsertContext.CompatibilityMode compatMode;

    public PersistentPutDir(String identifier, FreenetURI publicURI, FreenetURI privateURI, int verbosity, short priorityClass, ClientRequest.Persistence persistence, boolean global, String defaultName, HashMap<String, Object> manifestElements, String token, boolean started, int maxRetries, boolean dontCompress, String compressorDescriptor, boolean wasDiskPut, boolean realTime, byte[] splitfileCryptoKey, InsertContext.CompatibilityMode cmode) {
        this.identifier = identifier;
        this.uri = publicURI;
        this.privateURI = privateURI;
        this.verbosity = verbosity;
        this.priorityClass = priorityClass;
        this.persistence = persistence;
        this.global = global;
        this.defaultName = defaultName;
        this.manifestElements = manifestElements;
        this.token = token;
        this.started = started;
        this.maxRetries = maxRetries;
        this.wasDiskPut = wasDiskPut;
        this.dontCompress = dontCompress;
        this.compressorDescriptor = compressorDescriptor;
        this.realTime = realTime;
        this.splitfileCryptoKey = splitfileCryptoKey;
        this.compatMode = cmode;
        this.cached = this.generateFieldSet();
    }

    private SimpleFieldSet generateFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.putSingle("Identifier", this.identifier);
        fs.putSingle("URI", this.uri.toString(false, false));
        if (this.privateURI != null) {
            fs.putSingle("PrivateURI", this.privateURI.toString(false, false));
        }
        fs.put("Verbosity", this.verbosity);
        fs.putSingle("Persistence", this.persistence.toString().toLowerCase());
        fs.put("PriorityClass", this.priorityClass);
        fs.put("Global", this.global);
        fs.putSingle("PutDirType", this.wasDiskPut ? "disk" : "complex");
        fs.putOverwrite("CompatibilityMode", this.compatMode.name());
        SimpleFieldSet files = new SimpleFieldSet(false);
        ManifestElement[] elements = BaseManifestPutter.flatten(this.manifestElements);
        fs.putSingle("DefaultName", this.defaultName);
        for (int i = 0; i < elements.length; ++i) {
            String num = Integer.toString(i);
            ManifestElement e = elements[i];
            String mimeOverride = e.getMimeTypeOverride();
            SimpleFieldSet subset = new SimpleFieldSet(false);
            FreenetURI tempURI = e.getTargetURI();
            subset.putSingle("Name", e.getName());
            if (tempURI != null) {
                subset.putSingle("UploadFrom", "redirect");
                subset.putSingle("TargetURI", tempURI.toString());
            } else {
                RandomAccessBucket origData = e.getData();
                Bucket data = origData;
                if (data instanceof DelayedFreeBucket) {
                    data = ((DelayedFreeBucket)data).getUnderlying();
                } else if (data instanceof DelayedFreeRandomAccessBucket) {
                    data = ((DelayedFreeRandomAccessBucket)data).getUnderlying();
                }
                subset.put("DataLength", e.getSize());
                if (mimeOverride != null) {
                    subset.putSingle("Metadata.ContentType", mimeOverride);
                }
                if (data == null) {
                    Logger.error(this, "Bucket already freed: " + e.getData() + " for " + e + " for " + e.getName() + " for " + this.identifier);
                } else if (data instanceof FileBucket) {
                    subset.putSingle("UploadFrom", "disk");
                    subset.putSingle("Filename", ((FileBucket)data).getFile().getPath());
                } else if (data instanceof PaddedEphemerallyEncryptedBucket || data instanceof NullBucket || data instanceof PersistentTempFileBucket || data instanceof TempBucketFactory.TempBucket || data instanceof EncryptedRandomAccessBucket) {
                    subset.putSingle("UploadFrom", "direct");
                } else {
                    throw new IllegalStateException("Don't know what to do with bucket: " + data);
                }
            }
            files.put(num, subset);
        }
        files.put("Count", elements.length);
        fs.put("Files", files);
        if (this.token != null) {
            fs.putSingle("ClientToken", this.token);
        }
        fs.put("Started", this.started);
        fs.put("MaxRetries", this.maxRetries);
        fs.put("DontCompress", this.dontCompress);
        if (this.compressorDescriptor != null) {
            fs.putSingle("Codecs", this.compressorDescriptor);
        }
        fs.put("RealTime", this.realTime);
        if (this.splitfileCryptoKey != null) {
            fs.putSingle("SplitfileCryptoKey", HexUtil.bytesToHex(this.splitfileCryptoKey));
        }
        return fs;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return this.cached;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "PersistentPut goes from server to client not the other way around", this.identifier, this.global);
    }
}

