/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import java.util.ArrayList;
import java.util.Enumeration;

public class FProxyFetchTracker
implements Runnable {
    private static volatile boolean logMINOR;
    final MultiValueTable<FreenetURI, FProxyFetchInProgress> fetchers = new MultiValueTable();
    final ClientContext context;
    private long fetchIdentifiers;
    private final FetchContext fctx;
    private final RequestClient rc;
    private boolean queuedJob;
    private boolean requeue;

    public FProxyFetchTracker(ClientContext context, FetchContext fctx, RequestClient rc) {
        this.context = context;
        this.fctx = fctx;
        this.rc = rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FProxyFetchWaiter makeFetcher(FreenetURI key, long maxSize, FetchContext fctx, FProxyFetchInProgress.REFILTER_POLICY refilterPolicy) throws FetchException {
        FProxyFetchInProgress progress;
        MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable = this.fetchers;
        synchronized (multiValueTable) {
            FProxyFetchWaiter waiter = this.makeWaiterForFetchInProgress(key, maxSize, fctx != null ? fctx : this.fctx);
            if (waiter != null) {
                return waiter;
            }
            progress = new FProxyFetchInProgress(this, key, maxSize, this.fetchIdentifiers++, this.context, fctx != null ? fctx : this.fctx, this.rc, refilterPolicy);
            this.fetchers.put(key, progress);
        }
        try {
            progress.start(this.context);
        }
        catch (FetchException e) {
            MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable2 = this.fetchers;
            synchronized (multiValueTable2) {
                this.fetchers.removeElement(key, progress);
            }
            throw e;
        }
        if (logMINOR) {
            Logger.minor(this, "Created new fetcher: " + progress, (Throwable)new Exception());
        }
        return progress.getWaiter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFetcher(FProxyFetchInProgress progress) {
        MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable = this.fetchers;
        synchronized (multiValueTable) {
            this.fetchers.removeElement(progress.uri, progress);
        }
    }

    public FProxyFetchWaiter makeWaiterForFetchInProgress(FreenetURI key, long maxSize, FetchContext fctx) {
        FProxyFetchInProgress progress = this.getFetchInProgress(key, maxSize, fctx);
        if (progress != null) {
            return progress.getWaiter();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FProxyFetchInProgress getFetchInProgress(FreenetURI key, long maxSize, FetchContext fctx) {
        MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable = this.fetchers;
        synchronized (multiValueTable) {
            Object[] check = this.fetchers.getArray(key);
            if (check != null) {
                for (int i = 0; i < check.length; ++i) {
                    FProxyFetchInProgress progress = (FProxyFetchInProgress)check[i];
                    if (progress.maxSize == maxSize && progress.notFinishedOrFatallyFinished() || progress.hasData()) {
                        if (logMINOR) {
                            Logger.minor(this, "Found " + progress);
                        }
                        if (fctx != null && !progress.fetchContextEquivalent(fctx)) continue;
                        if (logMINOR) {
                            Logger.minor(this, "Using " + progress);
                        }
                        return progress;
                    }
                    if (!logMINOR) continue;
                    Logger.minor(this, "Skipping " + progress);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueCancel(FProxyFetchInProgress progress) {
        if (logMINOR) {
            Logger.minor(this, "Queueing removal of old FProxyFetchInProgress's");
        }
        FProxyFetchTracker fProxyFetchTracker = this;
        synchronized (fProxyFetchTracker) {
            if (this.queuedJob) {
                this.requeue = true;
                return;
            }
            this.queuedJob = true;
        }
        this.context.ticker.queueTimedJob(this, FProxyFetchInProgress.LIFETIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (logMINOR) {
            Logger.minor(this, "Removing old FProxyFetchInProgress's");
        }
        ArrayList<FProxyFetchInProgress> toRemove = null;
        boolean needRequeue = false;
        MultiValueTable<FreenetURI, FProxyFetchInProgress> multiValueTable = this.fetchers;
        synchronized (multiValueTable) {
            if (this.requeue) {
                this.requeue = false;
                needRequeue = true;
            } else {
                this.queuedJob = false;
            }
            Enumeration<FreenetURI> e = this.fetchers.keys();
            while (e.hasMoreElements()) {
                FreenetURI uri = e.nextElement();
                for (FProxyFetchInProgress f : this.fetchers.iterateAll(uri)) {
                    if (!f.canCancel()) continue;
                    if (toRemove == null) {
                        toRemove = new ArrayList<FProxyFetchInProgress>();
                    }
                    toRemove.add(f);
                }
            }
            if (toRemove != null) {
                for (FProxyFetchInProgress r : toRemove) {
                    if (logMINOR) {
                        Logger.minor(this, "Removed fetchinprogress:" + r);
                    }
                    this.fetchers.removeElement(r.uri, r);
                }
            }
        }
        if (toRemove != null) {
            for (FProxyFetchInProgress r : toRemove) {
                if (logMINOR) {
                    Logger.minor(this, "Cancelling for " + r);
                }
                r.finishCancel();
            }
        }
        if (needRequeue) {
            this.context.ticker.queueTimedJob(this, FProxyFetchInProgress.LIFETIME);
        }
    }

    public int makeRandomElementID() {
        return this.context.fastWeakRandom.nextInt();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

