/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.updateableelements;

import freenet.client.FetchContext;
import freenet.clients.http.FProxyFetchInProgress;
import freenet.clients.http.FProxyFetchResult;
import freenet.clients.http.FProxyFetchTracker;
import freenet.clients.http.FProxyFetchWaiter;
import freenet.clients.http.SimpleToadletServer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.updateableelements.BaseUpdateableElement;
import freenet.clients.http.updateableelements.NotifierFetchListener;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.support.Base64;
import freenet.support.HTMLNode;
import java.text.NumberFormat;

public class ProgressBarElement
extends BaseUpdateableElement {
    private final FProxyFetchTracker tracker;
    private final FreenetURI key;
    private final long maxSize;
    private final NotifierFetchListener fetchListener;
    private final FetchContext fctx;

    public ProgressBarElement(FProxyFetchTracker tracker, FreenetURI key, FetchContext fctx, long maxSize, ToadletContext ctx, boolean pushed) {
        super("div", "class", "progressbar", ctx);
        this.tracker = tracker;
        this.key = key;
        this.fctx = fctx;
        this.maxSize = maxSize;
        this.init(pushed);
        if (!pushed) {
            this.fetchListener = null;
            return;
        }
        this.fetchListener = new NotifierFetchListener(((SimpleToadletServer)ctx.getContainer()).pushDataManager, this);
        tracker.getFetchInProgress(key, maxSize, fctx).addListener(this.fetchListener);
    }

    @Override
    public void updateState(boolean initial) {
        FProxyFetchResult fr;
        this.children.clear();
        FProxyFetchInProgress progress = this.tracker.getFetchInProgress(this.key, this.maxSize, this.fctx);
        FProxyFetchWaiter waiter = progress == null ? null : progress.getWaiter();
        FProxyFetchResult fProxyFetchResult = fr = waiter == null ? null : waiter.getResult();
        if (fr == null) {
            this.addChild("div", "No fetcher found");
        } else if (fr.isFinished() || fr.hasData() || fr.failed != null) {
            this.setContent("Finished");
        } else {
            int total = fr.requiredBlocks;
            int fetchedPercent = (int)((double)fr.fetchedBlocks / (double)total * 100.0);
            int failedPercent = (int)((double)fr.failedBlocks / (double)total * 100.0);
            int fatallyFailedPercent = (int)((double)fr.fatallyFailedBlocks / (double)total * 100.0);
            HTMLNode progressBar = this.addChild("div", "class", "progressbar");
            progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-done", "width: " + fetchedPercent + "%;"});
            if (fr.failedBlocks > 0) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed", "width: " + failedPercent + "%;"});
            }
            if (fr.fatallyFailedBlocks > 0) {
                progressBar.addChild("div", new String[]{"class", "style"}, new String[]{"progressbar-failed2", "width: " + fatallyFailedPercent + "%;"});
            }
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(1);
            String prefix = '(' + Integer.toString(fr.fetchedBlocks) + "/ " + Integer.toString(total) + "): ";
            if (fr.finalizedBlocks) {
                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_finalized", prefix + NodeL10n.getBase().getString("QueueToadlet.progressbarAccurate")}, nf.format((double)((int)((double)fr.fetchedBlocks / (double)total * 1000.0)) / 10.0) + '%');
            } else {
                String text = nf.format((double)((int)((double)fr.fetchedBlocks / (double)total * 1000.0)) / 10.0) + '%';
                text = "" + fr.fetchedBlocks + " (" + text + "??)";
                progressBar.addChild("div", new String[]{"class", "title"}, new String[]{"progress_fraction_not_finalized", prefix + NodeL10n.getBase().getString("QueueToadlet.progressbarNotAccurate")}, text);
            }
        }
        if (waiter != null) {
            progress.close(waiter);
        }
        if (fr != null) {
            progress.close(fr);
        }
    }

    @Override
    public String getUpdaterId(String requestId) {
        return ProgressBarElement.getId(this.key);
    }

    public static String getId(FreenetURI uri) {
        return Base64.encodeStandardUTF8("progressbar[URI:" + uri.toString() + "]");
    }

    @Override
    public void dispose() {
        FProxyFetchInProgress progress = this.tracker.getFetchInProgress(this.key, this.maxSize, this.fctx);
        if (progress != null) {
            progress.removeListener(this.fetchListener);
        }
    }

    @Override
    public String getUpdaterType() {
        return "progressBar";
    }

    public String toString() {
        return "ProgressBarElement[key:" + this.key + ",maxSize:" + this.maxSize + ",updaterId:" + this.getUpdaterId(null) + "]";
    }
}

