/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.JceLoader;
import freenet.support.Logger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public class ECDH {
    public final Curves curve;
    private final KeyPair key;

    public ECDH(Curves curve) {
        this.curve = curve;
        this.key = curve.generateKeyPair();
    }

    public byte[] getAgreedSecret(ECPublicKey pubkey) {
        try {
            KeyAgreement ka = null;
            ka = KeyAgreement.getInstance("ECDH", this.curve.kaProvider);
            ka.init(this.key.getPrivate());
            ka.doPhase(pubkey, true);
            return ka.generateSecret();
        }
        catch (InvalidKeyException e) {
            Logger.error(this, "InvalidKeyException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(this, "NoSuchAlgorithmException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return null;
    }

    public ECPublicKey getPublicKey() {
        return (ECPublicKey)this.key.getPublic();
    }

    public static ECPublicKey getPublicKey(byte[] data, Curves curve) {
        ECPublicKey remotePublicKey = null;
        try {
            X509EncodedKeySpec ks = new X509EncodedKeySpec(data);
            KeyFactory kf = KeyFactory.getInstance("EC", curve.kfProvider);
            remotePublicKey = (ECPublicKey)kf.generatePublic(ks);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(ECDH.class, "NoSuchAlgorithmException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            Logger.error(ECDH.class, "InvalidKeySpecException : " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return remotePublicKey;
    }

    public static void blockingInit() {
        Curves.P256.getKeyPairGenerator();
    }

    public byte[] getPublicKeyNetworkFormat() {
        byte[] ret = this.getPublicKey().getEncoded();
        if (ret.length == this.curve.modulusSize) {
            return ret;
        }
        if (ret.length > this.curve.modulusSize) {
            throw new IllegalStateException("Encoded public key too long: should be " + this.curve.modulusSize + " bytes but is " + ret.length);
        }
        Logger.warning(this, "Padding public key from " + ret.length + " to " + this.curve.modulusSize + " bytes");
        byte[] out = new byte[this.curve.modulusSize];
        System.arraycopy(ret, 0, out, 0, ret.length);
        return ret;
    }

    public static enum Curves {
        P256("secp256r1", 91, 32),
        P384("secp384r1", 120, 48),
        P521("secp521r1", 158, 66);

        public final ECGenParameterSpec spec;
        private KeyPairGenerator keygenCached;
        protected final Provider kgProvider;
        protected final Provider kfProvider;
        protected final Provider kaProvider;
        public final int modulusSize;
        public final int derivedSecretSize;

        private static KeyPair selftest(KeyPairGenerator kg, KeyFactory kf, int modulusSize) throws InvalidKeySpecException {
            KeyPair key = kg.generateKeyPair();
            PublicKey pub = key.getPublic();
            PrivateKey pk = key.getPrivate();
            byte[] pubkey = pub.getEncoded();
            byte[] pkey = pk.getEncoded();
            if (pubkey.length > modulusSize || pubkey.length == 0) {
                throw new Error("Unexpected pubkey length: " + pubkey.length + "!=" + modulusSize);
            }
            PublicKey pub2 = kf.generatePublic(new X509EncodedKeySpec(pubkey));
            if (!Arrays.equals(pub2.getEncoded(), pubkey)) {
                throw new Error("Pubkey encoding mismatch");
            }
            PrivateKey pk2 = kf.generatePrivate(new PKCS8EncodedKeySpec(pkey));
            return key;
        }

        private static void selftest_genSecret(KeyPair key, KeyAgreement ka) throws InvalidKeyException {
            ka.init(key.getPrivate());
            ka.doPhase(key.getPublic(), true);
            ka.generateSecret();
        }

        private Curves(String name, int modulusSize, int derivedSecretSize) {
            this.spec = new ECGenParameterSpec(name);
            KeyAgreement ka = null;
            KeyFactory kf = null;
            KeyPairGenerator kg = null;
            JceLoader.BouncyCastle.toString();
            try {
                KeyPair key = null;
                try {
                    kg = KeyPairGenerator.getInstance("EC");
                    kf = KeyFactory.getInstance("EC");
                    kg.initialize(this.spec);
                    key = Curves.selftest(kg, kf, modulusSize);
                }
                catch (Throwable e) {
                    Logger.warning((Object)this, "default KeyPairGenerator provider (" + (kg != null ? kg.getProvider() : null) + ") is broken, falling back to BouncyCastle", e);
                    kg = KeyPairGenerator.getInstance("EC", JceLoader.BouncyCastle);
                    kf = KeyFactory.getInstance("EC", JceLoader.BouncyCastle);
                    kg.initialize(this.spec);
                    key = Curves.selftest(kg, kf, modulusSize);
                }
                try {
                    ka = KeyAgreement.getInstance("ECDH");
                    Curves.selftest_genSecret(key, ka);
                }
                catch (Throwable e) {
                    Logger.warning((Object)this, "default KeyAgreement provider (" + (ka != null ? ka.getProvider() : null) + ") is broken or incompatible with KeyPairGenerator, falling back to BouncyCastle", e);
                    kg = KeyPairGenerator.getInstance("EC", JceLoader.BouncyCastle);
                    kf = KeyFactory.getInstance("EC", JceLoader.BouncyCastle);
                    kg.initialize(this.spec);
                    ka = KeyAgreement.getInstance("ECDH", JceLoader.BouncyCastle);
                    Curves.selftest_genSecret(key, ka);
                }
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println(e);
                e.printStackTrace(System.out);
            }
            catch (InvalidKeySpecException e) {
                System.out.println(e);
                e.printStackTrace(System.out);
            }
            catch (InvalidKeyException e) {
                System.out.println(e);
                e.printStackTrace(System.out);
            }
            catch (InvalidAlgorithmParameterException e) {
                System.out.println(e);
                e.printStackTrace(System.out);
            }
            this.modulusSize = modulusSize;
            this.derivedSecretSize = derivedSecretSize;
            this.kgProvider = kg.getProvider();
            this.kfProvider = kf.getProvider();
            this.kaProvider = ka.getProvider();
            Logger.normal((Object)this, name + ": using " + this.kgProvider + " for KeyPairGenerator(EC)");
            Logger.normal((Object)this, name + ": using " + this.kfProvider + " for KeyFactory(EC)");
            Logger.normal((Object)this, name + ": using " + this.kaProvider + " for KeyAgreement(ECDH)");
        }

        private synchronized KeyPairGenerator getKeyPairGenerator() {
            if (this.keygenCached != null) {
                return this.keygenCached;
            }
            KeyPairGenerator kg = null;
            try {
                kg = KeyPairGenerator.getInstance("EC", this.kgProvider);
                kg.initialize(this.spec);
            }
            catch (NoSuchAlgorithmException e) {
                Logger.error(ECDH.class, "NoSuchAlgorithmException : " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            catch (InvalidAlgorithmParameterException e) {
                Logger.error(ECDH.class, "InvalidAlgorithmParameterException : " + e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            this.keygenCached = kg;
            return kg;
        }

        public synchronized KeyPair generateKeyPair() {
            return this.getKeyPairGenerator().generateKeyPair();
        }

        public String toString() {
            return this.spec.getName();
        }
    }
}

