/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.support.Logger;
import freenet.support.Serializer;
import freenet.support.ShortBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MessageType {
    public static final String VERSION = "$Id: MessageType.java,v 1.6 2005/08/25 17:28:19 amphibian Exp $";
    private static HashMap<Integer, MessageType> _specs = new HashMap();
    private final String _name;
    private final LinkedList<String> _orderedFields = new LinkedList();
    private final HashMap<String, Class<?>> _fields = new HashMap();
    private final HashMap<String, Class<?>> _linkedListTypes = new HashMap();
    private final boolean internalOnly;
    private final short priority;
    private final boolean isLossyPacketMessage;

    public MessageType(String name, short priority) {
        this(name, priority, false, false);
    }

    public MessageType(String name, short priority, boolean internal, boolean isLossyPacketMessage) {
        this._name = name;
        this.priority = priority;
        this.isLossyPacketMessage = isLossyPacketMessage;
        this.internalOnly = internal;
        Integer id = name.hashCode();
        if (_specs.containsKey(id)) {
            throw new RuntimeException("A message type by the name of " + name + " already exists!");
        }
        _specs.put(id, this);
    }

    public void unregister() {
        _specs.remove(this._name.hashCode());
    }

    public void addLinkedListField(String name, Class<?> parameter) {
        this._linkedListTypes.put(name, parameter);
        this.addField(name, LinkedList.class);
    }

    public void addField(String name, Class<?> type) {
        this._fields.put(name, type);
        this._orderedFields.addLast(name);
    }

    public void addRoutedToNodeMessageFields() {
        this.addField("uid", Long.class);
        this.addField("targetLocation", Double.class);
        this.addField("hopsToLive", Short.class);
        this.addField("nodeIdentity", ShortBuffer.class);
    }

    public boolean checkType(String fieldName, Object fieldValue) {
        if (fieldValue == null) {
            return false;
        }
        Class<?> defClass = this._fields.get(fieldName);
        if (defClass == null) {
            throw new IllegalStateException("Cannot set field \"" + fieldName + "\" which is not defined" + " in the message type \"" + this.getName() + "\".");
        }
        Class<?> valueClass = fieldValue.getClass();
        if (defClass == valueClass) {
            return true;
        }
        return defClass.isAssignableFrom(valueClass);
    }

    public Class<?> typeOf(String field) {
        return this._fields.get(field);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MessageType)) {
            return false;
        }
        return ((MessageType)o)._name == this._name;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static MessageType getSpec(Integer specID, boolean dontLog) {
        MessageType id = _specs.get(specID);
        if (id == null && !dontLog) {
            Logger.error(MessageType.class, "Unrecognised message type received (" + specID + ')');
        }
        return id;
    }

    public String getName() {
        return this._name;
    }

    public Map<String, Class<?>> getFields() {
        return this._fields;
    }

    public LinkedList<String> getOrderedFields() {
        return this._orderedFields;
    }

    public Map<String, Class<?>> getLinkedListTypes() {
        return this._linkedListTypes;
    }

    public boolean isInternalOnly() {
        return this.internalOnly;
    }

    public short getDefaultPriority() {
        return this.priority;
    }

    public int getMaxSize(int maxStringLength) {
        int length = 0;
        length += 4;
        for (Map.Entry<String, Class<?>> entry : this._fields.entrySet()) {
            length += Serializer.length(entry.getValue(), maxStringLength);
        }
        return length;
    }

    public boolean isLossyPacketMessage() {
        return this.isLossyPacketMessage;
    }
}

