/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.PeerManager;
import freenet.node.PeerNode;
import freenet.support.Logger;
import freenet.support.WeakHashSet;
import java.util.HashMap;
import java.util.List;

class PeerStatusTracker<K> {
    private static volatile boolean logMINOR;
    private final HashMap<K, WeakHashSet<PeerNode>> statuses = new HashMap();

    PeerStatusTracker() {
    }

    public synchronized void addStatus(K peerNodeStatus, PeerNode peerNode, boolean noLog) {
        WeakHashSet<PeerNode> statusSet = this.statuses.get(peerNodeStatus);
        if (statusSet != null) {
            if (statusSet.contains(peerNode)) {
                if (!noLog) {
                    Logger.error(this, "addPeerNodeStatus(): node already in peerNodeStatuses: " + peerNode + " status " + peerNodeStatus, (Throwable)new Exception("debug"));
                }
                return;
            }
            this.statuses.remove(peerNodeStatus);
        } else {
            statusSet = new WeakHashSet();
        }
        if (logMINOR) {
            Logger.minor(this, "addPeerNodeStatus(): adding PeerNode for '" + peerNode.getIdentityString() + "' with status '" + peerNodeStatus + "'");
        }
        statusSet.add(peerNode);
        this.statuses.put(peerNodeStatus, statusSet);
    }

    public synchronized int statusSize(K pnStatus) {
        WeakHashSet<PeerNode> statusSet = this.statuses.get(pnStatus);
        if (statusSet != null) {
            return statusSet.size();
        }
        return 0;
    }

    public synchronized void removeStatus(K peerNodeStatus, PeerNode peerNode, boolean noLog) {
        WeakHashSet<PeerNode> statusSet = this.statuses.get(peerNodeStatus);
        if (statusSet != null) {
            if (!statusSet.remove(peerNode)) {
                if (!noLog) {
                    Logger.error(this, "removePeerNodeStatus(): identity '" + peerNode.getIdentityString() + " for " + peerNode.shortToString() + "' not in peerNodeStatuses with status '" + peerNodeStatus + "'", (Throwable)new Exception("debug"));
                }
                return;
            }
            if (statusSet.isEmpty()) {
                this.statuses.remove(peerNodeStatus);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "removePeerNodeStatus(): removing PeerNode for '" + peerNode.getIdentityString() + "' with status '" + peerNodeStatus + "'");
        }
    }

    public synchronized void changePeerNodeStatus(PeerNode peerNode, K oldPeerNodeStatus, K peerNodeStatus, boolean noLog) {
        if (logMINOR) {
            Logger.minor(this, "Peer status change: " + oldPeerNodeStatus + " -> " + peerNodeStatus + " on " + peerNode);
        }
        this.removeStatus(oldPeerNodeStatus, peerNode, noLog);
        this.addStatus(peerNodeStatus, peerNode, noLog);
    }

    public synchronized void addStatusList(List<K> list) {
        list.addAll(this.statuses.keySet());
    }

    static {
        Logger.registerClass(PeerManager.class);
    }
}

