/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.MemoryLimitedJobRunner;

public final class MemoryLimitedChunk {
    private final MemoryLimitedJobRunner memoryLimitedJobRunner;
    private long used;

    MemoryLimitedChunk(MemoryLimitedJobRunner memoryLimitedJobRunner, long used) {
        this.memoryLimitedJobRunner = memoryLimitedJobRunner;
        if (used < 0L) {
            throw new IllegalArgumentException();
        }
        this.used = used;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long release() {
        long released = 0L;
        MemoryLimitedChunk memoryLimitedChunk = this;
        synchronized (memoryLimitedChunk) {
            if (this.used == 0L) {
                return 0L;
            }
            released = this.used;
            this.used = 0L;
        }
        this.memoryLimitedJobRunner.deallocate(released, true);
        return released;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long release(long amount) {
        boolean finishedThread = false;
        MemoryLimitedChunk memoryLimitedChunk = this;
        synchronized (memoryLimitedChunk) {
            if (amount > this.used) {
                throw new IllegalArgumentException("Only have " + this.used + " in use but asked to release " + amount);
            }
            this.used -= amount;
            finishedThread = this.used == 0L;
        }
        this.memoryLimitedJobRunner.deallocate(amount, finishedThread);
        return amount;
    }

    MemoryLimitedJobRunner getRunner() {
        return this.memoryLimitedJobRunner;
    }
}

