/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

public class SizeUtil {
    public static final String[] suffixes = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};

    public static String formatSize(long bytes) {
        return SizeUtil.formatSize(bytes, false);
    }

    public static String formatSizeWithoutSpace(long bytes) {
        String[] result = SizeUtil._formatSize(bytes);
        return result[0].concat(result[1]);
    }

    public static String formatSize(long bytes, boolean useNonBreakingSpace) {
        String[] result = SizeUtil._formatSize(bytes);
        return result[0].concat(useNonBreakingSpace ? "\u00a0" : " ").concat(result[1]);
    }

    public static String[] _formatSize(long bytes) {
        int i;
        boolean negative;
        long s = 1L;
        boolean bl = negative = bytes < 0L;
        if (negative) {
            bytes *= -1L;
        }
        for (i = 0; i < suffixes.length && s <= 0x1FFFFFFFFFFFFFL && s * 1024L <= bytes; s *= 1024L, ++i) {
        }
        if (s == 1L) {
            return new String[]{(negative ? "-" : "") + String.valueOf(bytes), suffixes[0]};
        }
        double mantissa = (double)bytes / (double)s;
        String o = String.valueOf(mantissa);
        if (o.indexOf(46) == 3) {
            o = o.substring(0, 3);
        } else if (o.indexOf(46) > -1 && o.indexOf(69) == -1 && o.length() > 4) {
            o = o.substring(0, 4);
        }
        if (negative) {
            o = "-" + o;
        }
        if (i < suffixes.length) {
            return new String[]{o, suffixes[i]};
        }
        return new String[]{o, ""};
    }
}

