/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountedInputStream
extends FilterInputStream {
    protected long count = 0L;

    public CountedInputStream(InputStream in) {
        super(in);
        if (in == null) {
            throw new IllegalStateException("null fed to CountedInputStream");
        }
    }

    public final long count() {
        return this.count;
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            ++this.count;
        }
        return ret;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        if (ret != -1) {
            this.count += (long)ret;
        }
        return ret;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        int ret = this.in.read(buf);
        if (ret != -1) {
            this.count += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long l = this.in.skip(n);
        if (l > 0L) {
            this.count += l;
        }
        return l;
    }
}

