/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.ApiException;
import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.IRCChannel;
import com.ircclouds.irc.api.domain.IRCServer;
import com.ircclouds.irc.api.domain.IRCTopic;
import com.ircclouds.irc.api.domain.IRCUser;
import com.ircclouds.irc.api.domain.IRCUserStatus;
import com.ircclouds.irc.api.domain.messages.AwayMessage;
import com.ircclouds.irc.api.domain.messages.ChanJoinMessage;
import com.ircclouds.irc.api.domain.messages.ChanPartMessage;
import com.ircclouds.irc.api.domain.messages.ChannelActionMsg;
import com.ircclouds.irc.api.domain.messages.ChannelKick;
import com.ircclouds.irc.api.domain.messages.ChannelModeMessage;
import com.ircclouds.irc.api.domain.messages.ChannelNotice;
import com.ircclouds.irc.api.domain.messages.ChannelPrivMsg;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.NickMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.domain.messages.TopicMessage;
import com.ircclouds.irc.api.domain.messages.interfaces.ISource;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ChatRoomMemberIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ClientConfig;
import net.java.sip.communicator.impl.protocol.irc.ISupport;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.MessageIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.Mode;
import net.java.sip.communicator.impl.protocol.irc.ModeParser;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.Result;
import net.java.sip.communicator.impl.protocol.irc.exception.UnknownModeException;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeEvent;
import net.java.sip.communicator.util.Logger;

public class ChannelManager {
    private static final Logger LOGGER = Logger.getLogger(ChannelManager.class);
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final ProtocolProviderServiceIrcImpl provider;
    private final ClientConfig config;
    private final Map<String, ChatRoomIrcImpl> joined = Collections.synchronizedMap(new HashMap());
    private final Integer isupportChannelLen;
    private final Integer isupportTopicLen;
    private final Integer isupportKickLen;
    private final Map<Character, Integer> isupportChanLimit = new HashMap<Character, Integer>();
    private final boolean awayNotify;

    public ChannelManager(IRCApi irc, IIRCState connectionState, ProtocolProviderServiceIrcImpl provider, ClientConfig config, boolean awayNotifyCapability) {
        if (irc == null) {
            throw new IllegalArgumentException("irc instance cannot be null");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState cannot be null");
        }
        this.connectionState = connectionState;
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = provider;
        if (config == null) {
            throw new IllegalArgumentException("client config cannot be null");
        }
        this.config = config;
        this.irc.addListener((IMessageListener)new ManagerListener());
        this.isupportChannelLen = ChannelManager.parseISupportInteger(this.connectionState, ISupport.CHANNELLEN);
        this.isupportTopicLen = ChannelManager.parseISupportInteger(this.connectionState, ISupport.TOPICLEN);
        this.isupportKickLen = ChannelManager.parseISupportInteger(this.connectionState, ISupport.KICKLEN);
        ChannelManager.parseISupportChanLimit(this.isupportChanLimit, this.connectionState);
        this.awayNotify = awayNotifyCapability;
    }

    private static Integer parseISupportInteger(IIRCState state, ISupport param) {
        String value = state.getServerOptions().getKey(param.name());
        if (value == null) {
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Setting ISUPPORT parameter " + param.name() + " to " + value));
        }
        return new Integer(value);
    }

    private static void parseISupportChanLimit(Map<Character, Integer> destination, IIRCState state) {
        String rawChanLimitValue = state.getServerOptions().getKey(ISupport.CHANLIMIT.name());
        ISupport.parseChanLimit(destination, rawChanLimitValue);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Parsed ISUPPORT CHANLIMIT parameter: " + rawChanLimitValue));
            for (Map.Entry<Character, Integer> e : destination.entrySet()) {
                LOGGER.debug((Object)(e.getKey() + ":" + e.getValue()));
            }
        }
    }

    public Set<Character> getChannelTypes() {
        return this.connectionState.getServerOptions().getChanTypes();
    }

    public boolean isJoined(ChatRoomIrcImpl chatroom) {
        return this.joined.get(chatroom.getIdentifier()) != null;
    }

    public void join(ChatRoomIrcImpl chatroom) throws OperationFailedException {
        this.join(chatroom, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(final ChatRoomIrcImpl chatroom, String password) throws OperationFailedException {
        Result joinSignal;
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Please connect to an IRC server first");
        }
        if (chatroom == null) {
            throw new IllegalArgumentException("chatroom cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null");
        }
        final String chatRoomId = chatroom.getIdentifier();
        if (this.joined.containsKey(chatRoomId)) {
            return;
        }
        if (this.isupportChannelLen != null && chatRoomId.length() > this.isupportChannelLen) {
            throw new IllegalArgumentException("the channel name must not be longer than " + this.isupportChannelLen + " characters according to server parameters.");
        }
        Integer limit = this.isupportChanLimit.get(Character.valueOf(chatRoomId.charAt(0)));
        if (limit != null && this.joined.size() >= limit) {
            throw new IllegalStateException("already joined to the maximum allowed number of channels (" + this.isupportChanLimit.toString() + ") according to server parameters.");
        }
        LOGGER.trace((Object)("Start joining channel " + chatRoomId));
        Result result = joinSignal = new Result();
        synchronized (result) {
            LOGGER.trace((Object)"Issue join channel command to IRC library and wait for join operation to complete (un)successfully.");
            this.joined.put(chatRoomId, null);
            this.irc.joinChannel(chatRoomId, password, (Callback)new Callback<IRCChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onSuccess(IRCChannel channel) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Started callback for successful join of channel '" + chatroom.getIdentifier() + "'."));
                    }
                    boolean isRequestedChatRoom = channel.getName().equalsIgnoreCase(chatRoomId);
                    Result result = joinSignal;
                    synchronized (result) {
                        if (!isRequestedChatRoom) {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace((Object)("Callback for successful join finished prematurely since we got forwarded from '" + chatRoomId + "' to '" + channel.getName() + "'. Joining of forwarded channel gets handled by Server Listener since that channel was not announced."));
                            }
                            ChannelManager.this.joined.remove(chatRoomId);
                            ChannelManager.this.provider.getMUC().fireLocalUserPresenceEvent((ChatRoom)chatroom, "LocalUserJoinFailed", "We got forwarded to channel '" + channel.getName() + "'.");
                            joinSignal.setDone();
                            joinSignal.notifyAll();
                            return;
                        }
                        try {
                            ChannelManager.this.joined.put(chatRoomId, chatroom);
                            ChannelManager.this.irc.addListener((IMessageListener)new ChatRoomListener(chatroom, ChannelManager.this.config.isChannelPresenceTaskEnabled(), ChannelManager.this.awayNotify));
                            ChannelManager.this.prepareChatRoom(chatroom, channel);
                        }
                        finally {
                            ChannelManager.this.provider.getMUC().fireLocalUserPresenceEvent((ChatRoom)chatroom, "LocalUserJoined", null);
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace((Object)("Finished successful join callback for channel '" + chatRoomId + "'. Waking up original thread."));
                            }
                            joinSignal.setDone();
                            joinSignal.notifyAll();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onFailure(Exception e) {
                    LOGGER.trace((Object)("Started callback for failed attempt to join channel '" + chatRoomId + "'."));
                    Result result = joinSignal;
                    synchronized (result) {
                        try {
                            ChannelManager.this.joined.remove(chatRoomId);
                            ChannelManager.this.provider.getMUC().fireLocalUserPresenceEvent((ChatRoom)chatroom, "LocalUserJoinFailed", e.getMessage());
                        }
                        finally {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace((Object)("Finished callback for failed attempt to join channel '" + chatRoomId + "'. Waking up original thread."));
                            }
                            joinSignal.setDone(e);
                            joinSignal.notifyAll();
                        }
                    }
                }
            });
            try {
                while (!joinSignal.isDone()) {
                    LOGGER.trace((Object)"Waiting for channel join message ...");
                    joinSignal.wait();
                }
                LOGGER.trace((Object)("Finished waiting for join operation for channel '" + chatroom.getIdentifier() + "' to complete."));
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Wait for join operation was interrupted.", (Throwable)e);
                throw new OperationFailedException(e.getMessage(), 4, (Throwable)e);
            }
        }
    }

    private void prepareChatRoom(ChatRoomIrcImpl chatRoom, IRCChannel channel) {
        IRCTopic topic = channel.getTopic();
        chatRoom.updateSubject(topic.getValue());
        for (IRCUser user : channel.getUsers()) {
            ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(this.provider, (ChatRoom)chatRoom, user.getNick(), user.getIdent(), user.getHostname(), ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
            for (IRCUserStatus status : channel.getStatusesForUser(user)) {
                try {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)("Processing role " + status.getPrefix() + " for member " + user.getNick() + " in channel " + channel.getName()));
                    }
                    ChatRoomMemberRole role = ChannelManager.convertMemberMode(status.getChanModeType().charValue());
                    member.addRole(role);
                }
                catch (UnknownModeException e) {
                    LOGGER.info((Object)"Unknown mode encountered. This mode will be ignored.", (Throwable)e);
                }
            }
            chatRoom.addChatRoomMember(member.getContactAddress(), member);
            if (!this.connectionState.getNickname().equals(user.getNick())) continue;
            chatRoom.setLocalUser(member);
            if (member.getRole() == ChatRoomMemberRole.SILENT_MEMBER) continue;
            ChatRoomLocalUserRoleChangeEvent event = new ChatRoomLocalUserRoleChangeEvent((ChatRoom)chatRoom, ChatRoomMemberRole.SILENT_MEMBER, member.getRole(), true);
            chatRoom.fireLocalUserRoleChangedEvent(event);
        }
    }

    public void setSubject(ChatRoomIrcImpl chatroom, String subject) {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Please connect to an IRC server first.");
        }
        if (chatroom == null) {
            throw new IllegalArgumentException("Cannot have a null chatroom");
        }
        if (this.isupportTopicLen != null && subject.length() > this.isupportTopicLen) {
            throw new IllegalArgumentException("the topic length must not be longer than " + this.isupportTopicLen + " characters according to server parameters.");
        }
        LOGGER.trace((Object)("Setting chat room topic to '" + subject + "'"));
        this.irc.changeTopic(chatroom.getIdentifier(), subject == null ? "" : subject);
    }

    public void leave(ChatRoomIrcImpl chatroom) {
        LOGGER.trace((Object)("Leaving chat room '" + chatroom.getIdentifier() + "'."));
        this.leave(chatroom.getIdentifier());
    }

    private void leave(String chatRoomName) {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to an IRC server.");
        }
        try {
            this.irc.leaveChannel(chatRoomName);
        }
        catch (ApiException e) {
            LOGGER.warn((Object)"exception occurred while leaving channel", (Throwable)e);
        }
    }

    public void grant(ChatRoomIrcImpl chatRoom, String userAddress, Mode mode) {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to an IRC server.");
        }
        if (mode.getRole() == null) {
            throw new IllegalArgumentException("This mode does not modify user permissions.");
        }
        this.irc.changeMode(chatRoom.getIdentifier() + " +" + mode.getSymbol() + " " + userAddress);
    }

    public void revoke(ChatRoomIrcImpl chatRoom, String userAddress, Mode mode) {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to an IRC server.");
        }
        if (mode.getRole() == null) {
            throw new IllegalArgumentException("This mode does not modify user permissions.");
        }
        this.irc.changeMode(chatRoom.getIdentifier() + " -" + mode.getSymbol() + " " + userAddress);
    }

    public void banParticipant(ChatRoomIrcImpl chatroom, ChatRoomMemberIrcImpl member, String reason) throws OperationFailedException {
        if (!this.connectionState.isConnected()) {
            return;
        }
        this.kickParticipant(chatroom, member, reason);
        this.irc.changeMode(String.format("%s +b %s!%s@%s", chatroom.getIdentifier(), "*", member.getIdent(), member.getHostname()));
    }

    public void kickParticipant(ChatRoomIrcImpl chatroom, ChatRoomMember member, String reason) {
        if (!this.connectionState.isConnected()) {
            return;
        }
        if (this.isupportKickLen != null && reason.length() > this.isupportKickLen) {
            throw new IllegalArgumentException("the kick reason must not be longer than " + this.isupportKickLen + " characters according to server parameters.");
        }
        this.irc.kick(chatroom.getIdentifier(), member.getContactAddress(), reason);
    }

    public void invite(String memberId, ChatRoomIrcImpl chatroom) {
        if (!this.connectionState.isConnected()) {
            throw new IllegalStateException("Not connected to an IRC server.");
        }
        this.irc.rawMessage("INVITE " + memberId + " " + chatroom.getIdentifier());
    }

    private static ChatRoomMemberRole convertMemberMode(char modeSymbol) throws UnknownModeException {
        return Mode.bySymbol(modeSymbol).getRole();
    }

    private final class ChatRoomListener
    extends AbstractIrcMessageListener {
        private static final String GONE = "G";
        private static final int IRC_ERR_CANNOTSENDTOCHAN = 404;
        private static final int IRC_ERR_NOTONCHANNEL = 442;
        private static final int IRC_RPL_WHOREPLY = 352;
        private static final int IRC_RPL_ENDOFWHO = 315;
        private static final long TASK_PERIOD = 60000L;
        private static final long TASK_INITIAL_DELAY = 60000L;
        private final ChatRoomIrcImpl chatroom;
        private final Timer presenceTaskTimer;

        private ChatRoomListener(ChatRoomIrcImpl chatroom, boolean activatePresenceWatcher, boolean awayNotifyCapability) {
            super(ChannelManager.this.irc, ChannelManager.this.connectionState);
            this.presenceTaskTimer = new Timer();
            if (chatroom == null) {
                throw new IllegalArgumentException("chatroom cannot be null");
            }
            this.chatroom = chatroom;
            if (activatePresenceWatcher && !awayNotifyCapability) {
                this.createPeriodicPresenceWatcher();
            } else {
                LOGGER.info((Object)("Not activating periodic presence watcher. (away-notify capability is " + awayNotifyCapability + ")"));
            }
            this.irc.rawMessage("WHO " + chatroom.getIdentifier());
        }

        private void createPeriodicPresenceWatcher() {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    ChatRoomListener.this.irc.rawMessage("WHO " + ChatRoomListener.this.chatroom.getIdentifier());
                }
            };
            this.presenceTaskTimer.schedule(task, 60000L, 60000L);
            LOGGER.debug((Object)("Scheduled periodic task for querying member presence for channel " + this.chatroom.getIdentifier()));
        }

        public void onTopicChange(TopicMessage msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            this.chatroom.updateSubject(msg.getTopic().getValue());
        }

        public void onChannelMode(ChannelModeMessage msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            this.processModeMessage(msg);
        }

        public void onChannelJoin(ChanJoinMessage msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            String user = msg.getSource().getNick();
            String ident = msg.getSource().getIdent();
            String host = msg.getSource().getHostname();
            ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(ChannelManager.this.provider, (ChatRoom)this.chatroom, user, ident, host, ChatRoomMemberRole.SILENT_MEMBER, IrcStatusEnum.ONLINE);
            this.chatroom.fireMemberPresenceEvent(member, null, "MemberJoined", null);
        }

        public void onChannelPart(ChanPartMessage msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            IRCUser user = msg.getSource();
            if (this.localUser(user)) {
                this.leaveChatRoom();
                return;
            }
            String userNick = msg.getSource().getNick();
            ChatRoomMember member = this.chatroom.getChatRoomMember(userNick);
            if (member != null) {
                try {
                    this.chatroom.fireMemberPresenceEvent(member, null, "MemberLeft", msg.getPartMsg());
                }
                catch (NullPointerException e) {
                    LOGGER.warn((Object)"This should not have happened. Please report this as it is a bug.", (Throwable)e);
                }
            }
        }

        public void onServerNumericMessage(ServerNumericMessage msg) {
            Integer code = msg.getNumericCode();
            if (code == null) {
                return;
            }
            String raw = msg.getText();
            switch (code) {
                case 442: {
                    String channel = raw.substring(0, raw.indexOf(" "));
                    if (!this.isThisChatRoom(channel)) break;
                    LOGGER.warn((Object)("Just discovered that we are no longer joined to channel " + channel + ". Leaving quietly. (This is most likely due to a bug in the implementation.)"));
                    this.leaveChatRoom();
                    break;
                }
                case 404: {
                    String cannotSendChannel = raw.substring(0, raw.indexOf(" "));
                    if (!this.isThisChatRoom(cannotSendChannel)) break;
                    MessageIrcImpl message = new MessageIrcImpl("", "text/plain", "UTF-8", null);
                    this.chatroom.fireMessageDeliveryFailedEvent(6, "This channel is moderated.", new Date(), (Message)message);
                    break;
                }
                case 352: {
                    String[] messageComponents = msg.getText().split(" ");
                    if (messageComponents.length < 6 || !this.isThisChatRoom(messageComponents[0])) {
                        return;
                    }
                    String nick = messageComponents[4];
                    ChatRoomMemberIrcImpl member = (ChatRoomMemberIrcImpl)this.chatroom.getChatRoomMember(nick);
                    if (member == null) break;
                    IrcStatusEnum status = this.determineStatus(messageComponents[5]);
                    this.updateMemberPresence(member, status);
                    break;
                }
            }
        }

        private IrcStatusEnum determineStatus(String presenceReply) {
            if (presenceReply != null && presenceReply.startsWith(GONE)) {
                return IrcStatusEnum.AWAY;
            }
            return IrcStatusEnum.ONLINE;
        }

        public void onChannelKick(ChannelKick msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            if (!this.connectionState.isConnected()) {
                LOGGER.error((Object)"Not currently connected to IRC Server. Aborting message handling.");
                return;
            }
            String kickedUser = msg.getKickedNickname();
            ChatRoomMember kickedMember = this.chatroom.getChatRoomMember(kickedUser);
            String user = msg.getSource().getNick();
            if (kickedMember != null) {
                ChatRoomMember kicker = this.chatroom.getChatRoomMember(user);
                this.chatroom.fireMemberPresenceEvent(kickedMember, kicker, "MemberKicked", msg.getText());
            }
            if (this.localUser(kickedUser)) {
                LOGGER.debug((Object)"Local user is kicked. Removing chat room listener.");
                this.irc.deleteListener((IMessageListener)this);
                ChannelManager.this.joined.remove(this.chatroom.getIdentifier());
                ChannelManager.this.provider.getMUC().fireLocalUserPresenceEvent((ChatRoom)this.chatroom, "LocalUserKicked", msg.getText());
            }
        }

        @Override
        public void onUserQuit(QuitMessage msg) {
            String user = msg.getSource().getNick();
            if (this.localUser(user)) {
                this.presenceTaskTimer.cancel();
            } else {
                ChatRoomMember member = this.chatroom.getChatRoomMember(user);
                if (member != null) {
                    this.chatroom.fireMemberPresenceEvent(member, null, "MemberQuit", msg.getQuitMsg());
                }
            }
            super.onUserQuit(msg);
        }

        @Override
        public void onError(ErrorMessage msg) {
            this.presenceTaskTimer.cancel();
            super.onError(msg);
        }

        @Override
        public void onClientError(ClientErrorMessage msg) {
            this.presenceTaskTimer.cancel();
            super.onClientError(msg);
        }

        public void onNickChange(NickMessage msg) {
            if (msg == null) {
                return;
            }
            String oldNick = msg.getSource().getNick();
            String newNick = msg.getNewNick();
            ChatRoomMemberIrcImpl member = (ChatRoomMemberIrcImpl)this.chatroom.getChatRoomMember(oldNick);
            if (member != null) {
                member.setName(newNick);
                this.chatroom.updateChatRoomMemberName(oldNick);
                ChatRoomMemberPropertyChangeEvent evt = new ChatRoomMemberPropertyChangeEvent((ChatRoomMember)member, (ChatRoom)this.chatroom, "MemberNickname", (Object)oldNick, (Object)newNick);
                this.chatroom.fireMemberPropertyChangeEvent(evt);
            }
        }

        public void onChannelMessage(ChannelPrivMsg msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            MessageIrcImpl message = MessageIrcImpl.newMessageFromIRC(msg.getText());
            ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(ChannelManager.this.provider, (ChatRoom)this.chatroom, msg.getSource().getNick(), msg.getSource().getIdent(), msg.getSource().getHostname(), ChatRoomMemberRole.MEMBER, IrcStatusEnum.ONLINE);
            this.chatroom.fireMessageReceivedEvent((Message)message, member, new Date(), 1);
        }

        public void onChannelAction(ChannelActionMsg msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            String userNick = msg.getSource().getNick();
            ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(ChannelManager.this.provider, (ChatRoom)this.chatroom, userNick, msg.getSource().getIdent(), msg.getSource().getHostname(), ChatRoomMemberRole.MEMBER, IrcStatusEnum.ONLINE);
            MessageIrcImpl message = MessageIrcImpl.newActionFromIRC(msg.getText());
            this.chatroom.fireMessageReceivedEvent((Message)message, member, new Date(), 2);
        }

        public void onChannelNotice(ChannelNotice msg) {
            if (!this.isThisChatRoom(msg.getChannelName())) {
                return;
            }
            String userNick = msg.getSource().getNick();
            ChatRoomMemberIrcImpl member = new ChatRoomMemberIrcImpl(ChannelManager.this.provider, (ChatRoom)this.chatroom, userNick, msg.getSource().getIdent(), msg.getSource().getHostname(), ChatRoomMemberRole.MEMBER, IrcStatusEnum.ONLINE);
            MessageIrcImpl message = MessageIrcImpl.newNoticeFromIRC(member, msg.getText());
            this.chatroom.fireMessageReceivedEvent((Message)message, member, new Date(), 1);
        }

        public void onUserAway(AwayMessage msg) {
            ChatRoomMemberIrcImpl member = (ChatRoomMemberIrcImpl)this.chatroom.getChatRoomMember(msg.getSource().getNick());
            if (member != null) {
                IrcStatusEnum status = msg.isAway() ? IrcStatusEnum.AWAY : IrcStatusEnum.ONLINE;
                this.updateMemberPresence(member, status);
            }
        }

        private void updateMemberPresence(ChatRoomMemberIrcImpl member, IrcStatusEnum newStatus) {
            IrcStatusEnum previous = member.setPresenceStatus(newStatus);
            if (previous == newStatus) {
                return;
            }
            ChatRoomMemberPropertyChangeEvent presenceEvent = new ChatRoomMemberPropertyChangeEvent((ChatRoomMember)member, (ChatRoom)this.chatroom, "MemberPresence", (Object)previous, (Object)newStatus);
            this.chatroom.fireMemberPropertyChangeEvent(presenceEvent);
        }

        private void leaveChatRoom() {
            this.presenceTaskTimer.cancel();
            this.irc.deleteListener((IMessageListener)this);
            ChannelManager.this.joined.remove(this.chatroom.getIdentifier());
            LOGGER.debug((Object)("Leaving chat room " + this.chatroom.getIdentifier() + ". Chat room listener removed."));
            ChannelManager.this.provider.getMUC().fireLocalUserPresenceEvent((ChatRoom)this.chatroom, "LocalUserLeft", null);
        }

        private void processModeMessage(ChannelModeMessage msg) {
            ChatRoomMemberIrcImpl source = this.extractChatRoomMember(msg);
            ModeParser parser = new ModeParser(msg.getModeStr());
            block6: for (ModeParser.ModeEntry mode : parser.getModes()) {
                switch (mode.getMode()) {
                    case OWNER: 
                    case OPERATOR: 
                    case HALFOP: 
                    case VOICE: {
                        this.processRoleChange(source, mode);
                        continue block6;
                    }
                    case LIMIT: {
                        this.processLimitChange(source, mode);
                        continue block6;
                    }
                    case BAN: {
                        this.processBanChange(source, mode);
                        continue block6;
                    }
                    case UNKNOWN: {
                        if (!LOGGER.isInfoEnabled()) continue block6;
                        LOGGER.info((Object)("Unknown mode: " + (mode.isAdded() ? "+" : "-") + mode.getParams()[0] + ". Original mode string: '" + msg.getModeStr() + "'"));
                        continue block6;
                    }
                }
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info((Object)("Unsupported mode '" + (mode.isAdded() ? "+" : "-") + (Object)((Object)mode.getMode()) + "' (from modestring '" + msg.getModeStr() + "')"));
            }
        }

        private void processBanChange(ChatRoomMemberIrcImpl sourceMember, ModeParser.ModeEntry mode) {
            MessageIrcImpl banMessage = new MessageIrcImpl("channel ban mask was " + (mode.isAdded() ? "added" : "removed") + ": " + mode.getParams()[0] + " by " + (sourceMember.getContactAddress().length() == 0 ? "server" : sourceMember.getContactAddress()), "text/plain", "UTF-8", null);
            this.chatroom.fireMessageReceivedEvent((Message)banMessage, sourceMember, new Date(), 3);
        }

        private void processRoleChange(ChatRoomMemberIrcImpl sourceMember, ModeParser.ModeEntry mode) {
            String targetNick = mode.getParams()[0];
            ChatRoomMemberIrcImpl targetMember = (ChatRoomMemberIrcImpl)this.chatroom.getChatRoomMember(targetNick);
            ChatRoomMemberRole originalRole = targetMember.getRole();
            if (mode.isAdded()) {
                targetMember.addRole(mode.getMode().getRole());
            } else {
                targetMember.removeRole(mode.getMode().getRole());
            }
            ChatRoomMemberRole newRole = targetMember.getRole();
            if (newRole != originalRole) {
                ChatRoomLocalUserRoleChangeEvent event = new ChatRoomLocalUserRoleChangeEvent((ChatRoom)this.chatroom, originalRole, newRole, false);
                if (this.localUser(targetMember.getContactAddress())) {
                    this.chatroom.fireLocalUserRoleChangedEvent(event);
                } else {
                    this.chatroom.fireMemberRoleEvent(targetMember, newRole);
                }
            } else {
                String text = sourceMember.getName() + (mode.isAdded() ? " gives " + mode.getMode().name().toLowerCase() + " to " : " removes " + mode.getMode().name().toLowerCase() + " from ") + targetMember.getName();
                MessageIrcImpl message = new MessageIrcImpl(text, "text/plain", "UTF-8", null);
                this.chatroom.fireMessageReceivedEvent((Message)message, sourceMember, new Date(), 3);
            }
        }

        private void processLimitChange(ChatRoomMemberIrcImpl sourceMember, ModeParser.ModeEntry mode) {
            MessageIrcImpl limitMessage;
            if (mode.isAdded()) {
                try {
                    limitMessage = new MessageIrcImpl("channel limit set to " + Integer.parseInt(mode.getParams()[0]) + " by " + (sourceMember.getContactAddress().length() == 0 ? "server" : sourceMember.getContactAddress()), "text/plain", "UTF-8", null);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn((Object)"server sent incorrect limit: limit is not a number", (Throwable)e);
                    return;
                }
            } else {
                limitMessage = new MessageIrcImpl("channel limit removed by " + (sourceMember.getContactAddress().length() == 0 ? "server" : sourceMember.getContactAddress()), "text/plain", "UTF-8", null);
            }
            this.chatroom.fireMessageReceivedEvent((Message)limitMessage, sourceMember, new Date(), 3);
        }

        private ChatRoomMemberIrcImpl extractChatRoomMember(ChannelModeMessage msg) {
            ChatRoomMemberIrcImpl member;
            ISource source = msg.getSource();
            if (source instanceof IRCServer) {
                member = new ChatRoomMemberIrcImpl(ChannelManager.this.provider, (ChatRoom)this.chatroom, "", "", "", ChatRoomMemberRole.ADMINISTRATOR, IrcStatusEnum.ONLINE);
            } else if (source instanceof IRCUser) {
                String nick = ((IRCUser)source).getNick();
                member = (ChatRoomMemberIrcImpl)this.chatroom.getChatRoomMember(nick);
            } else {
                throw new IllegalArgumentException("Unknown source type: " + source.getClass().getName());
            }
            return member;
        }

        private boolean isThisChatRoom(String chatRoomName) {
            return this.chatroom.getIdentifier().equalsIgnoreCase(chatRoomName);
        }

        private boolean localUser(IRCUser user) {
            return this.localUser(user.getNick());
        }
    }

    private final class ManagerListener
    extends AbstractIrcMessageListener {
        private static final int RPL_LISTEND = 366;

        public ManagerListener() {
            super(ChannelManager.this.irc, ChannelManager.this.connectionState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServerNumericMessage(ServerNumericMessage msg) {
            switch (msg.getNumericCode()) {
                case 366: {
                    ChatRoomIrcImpl chatRoom;
                    IRCChannel channel;
                    String text = msg.getText();
                    String channelName = text.substring(0, text.indexOf(32));
                    Map map = ChannelManager.this.joined;
                    synchronized (map) {
                        if (ChannelManager.this.joined.containsKey(channelName)) {
                            LOGGER.trace((Object)("Chat room '" + channelName + "' join event was announced or already finished. Stop handling this event."));
                            break;
                        }
                        LOGGER.trace((Object)("Starting unannounced join of chat room '" + channelName + "'"));
                        channel = this.connectionState.getChannelByName(channelName);
                        chatRoom = new ChatRoomIrcImpl(channelName, ChannelManager.this.provider);
                        ChannelManager.this.joined.put(channelName, chatRoom);
                    }
                    this.irc.addListener((IMessageListener)new ChatRoomListener(chatRoom, ChannelManager.this.config.isChannelPresenceTaskEnabled(), ChannelManager.this.awayNotify));
                    try {
                        ChannelManager.this.provider.getMUC().openChatRoomWindow(chatRoom);
                    }
                    catch (NullPointerException e) {
                        LOGGER.error((Object)"failed to open chat room window", (Throwable)e);
                    }
                    ChannelManager.this.prepareChatRoom(chatRoom, channel);
                    ChannelManager.this.provider.getMUC().fireLocalUserPresenceEvent((ChatRoom)chatRoom, "LocalUserJoined", null);
                    LOGGER.trace((Object)("Unannounced join of chat room '" + channelName + "' completed."));
                    break;
                }
            }
        }
    }
}

