/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.provdisc.dhcp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.util.Logger;

public class DHCPTransaction {
    private final Logger logger = Logger.getLogger(DHCPTransaction.class);
    private int maxRetransmit = 2;
    private int nbRetransmit = 0;
    private int interval = 2;
    private Timer timer = null;
    private final DatagramPacket message;
    private final DatagramSocket sock;

    public DHCPTransaction(DatagramSocket sock, DatagramPacket message) {
        this.sock = sock;
        this.message = message;
        this.timer = new Timer();
    }

    public void schedule() throws Exception {
        this.sock.send(this.message);
        int rand = new Random().nextInt(2) - 1;
        this.timer.schedule((TimerTask)new RetransmissionHandler(), (this.interval + rand) * 1000);
    }

    public void cancel() {
        this.timer.cancel();
    }

    public void setMaxRetransmit(int maxRetransmit) {
        this.maxRetransmit = maxRetransmit;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    private class RetransmissionHandler
    extends TimerTask {
        private RetransmissionHandler() {
        }

        @Override
        public void run() {
            int rand = new Random().nextInt(2) - 1;
            try {
                DHCPTransaction.this.sock.send(DHCPTransaction.this.message);
            }
            catch (Exception e) {
                DHCPTransaction.this.logger.warn((Object)"Failed to send DHCP packet", (Throwable)e);
            }
            DHCPTransaction.this.nbRetransmit++;
            if (DHCPTransaction.this.nbRetransmit < DHCPTransaction.this.maxRetransmit) {
                DHCPTransaction.this.timer.schedule((TimerTask)new RetransmissionHandler(), (DHCPTransaction.this.interval + rand) * 1000);
            }
        }
    }
}

