/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProviderManagerExt;
import net.java.sip.communicator.impl.protocol.jabber.SmackV3InteroperabilityLayer;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.jabber.AbstractSmackInteroperabilityLayer;
import net.java.sip.communicator.service.protocol.jabber.JabberAccountID;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ProtocolProviderFactoryJabberImpl
extends ProtocolProviderFactory {
    public static final String IS_USE_JINGLE_NODES = "JINGLE_NODES_ENABLED";
    static ProviderManager providerManager = null;

    protected ProtocolProviderFactoryJabberImpl() {
        super(JabberActivator.getBundleContext(), "Jabber");
    }

    protected void storeAccount(AccountID accountID) {
        super.storeAccount(accountID);
    }

    public AccountID installAccount(String userIDStr, Map<String, String> accountProperties) {
        JabberAccountIDImpl accountID;
        BundleContext context = JabberActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (userIDStr == null) {
            throw new NullPointerException("The specified AccountID was null");
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        accountProperties.put("USER_ID", userIDStr);
        if (accountProperties.get("SERVER_ADDRESS") == null) {
            String serverAddress = StringUtils.parseServer((String)userIDStr);
            if (serverAddress != null) {
                accountProperties.put("SERVER_ADDRESS", StringUtils.parseServer((String)userIDStr));
            } else {
                throw new IllegalArgumentException("Should specify a server for user name " + userIDStr + ".");
            }
        }
        if (accountProperties.get("SERVER_PORT") == null) {
            accountProperties.put("SERVER_PORT", "5222");
        }
        if (this.registeredAccounts.containsKey((Object)(accountID = new JabberAccountIDImpl(userIDStr, accountProperties)))) {
            throw new IllegalStateException("An account for id " + userIDStr + " was already installed!");
        }
        this.storeAccount((AccountID)accountID, false);
        accountID = this.loadAccount(accountProperties);
        return accountID;
    }

    protected AccountID createAccountID(String userID, Map<String, String> accountProperties) {
        return new JabberAccountIDImpl(userID, accountProperties);
    }

    protected ProtocolProviderService createService(String userID, AccountID accountID) {
        ProtocolProviderServiceJabberImpl service = new ProtocolProviderServiceJabberImpl();
        service.initialize(userID, (JabberAccountID)accountID);
        return service;
    }

    public void modifyAccount(ProtocolProviderService protocolProvider, Map<String, String> accountProperties) throws NullPointerException {
        BundleContext context = JabberActivator.getBundleContext();
        if (context == null) {
            throw new NullPointerException("The specified BundleContext was null");
        }
        if (protocolProvider == null) {
            throw new NullPointerException("The specified Protocol Provider was null");
        }
        JabberAccountIDImpl accountID = (JabberAccountIDImpl)protocolProvider.getAccountID();
        if (!this.registeredAccounts.containsKey((Object)accountID)) {
            return;
        }
        ServiceRegistration registration = (ServiceRegistration)this.registeredAccounts.get((Object)accountID);
        if (registration != null) {
            try {
                if (protocolProvider.isRegistered()) {
                    protocolProvider.unregister();
                    protocolProvider.shutdown();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            registration.unregister();
        }
        if (accountProperties == null) {
            throw new NullPointerException("The specified property map was null");
        }
        accountProperties.put("USER_ID", accountID.getUserID());
        String serverAddress = accountProperties.get("SERVER_ADDRESS");
        if (serverAddress == null) {
            throw new NullPointerException("null is not a valid ServerAddress");
        }
        if (accountProperties.get("SERVER_PORT") == null) {
            accountProperties.put("SERVER_PORT", "5222");
        }
        if (!accountProperties.containsKey("PROTOCOL_NAME")) {
            accountProperties.put("PROTOCOL_NAME", "Jabber");
        }
        accountID.setAccountProperties(accountProperties);
        this.storeAccount((AccountID)accountID);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("PROTOCOL_NAME", "Jabber");
        properties.put("USER_ID", accountID.getUserID());
        ((ProtocolProviderServiceJabberImpl)protocolProvider).initialize(accountID.getUserID(), accountID);
        this.storeAccount((AccountID)accountID);
        registration = context.registerService(ProtocolProviderService.class.getName(), (Object)protocolProvider, properties);
        this.registeredAccounts.put(accountID, registration);
    }

    static {
        try {
            ProviderManager.setInstance((ProviderManager)new ProviderManagerExt());
            AbstractSmackInteroperabilityLayer.setImplementationClass(SmackV3InteroperabilityLayer.class);
        }
        catch (Throwable throwable) {
        }
        finally {
            providerManager = ProviderManager.getInstance();
        }
        if (!providerManager.getClass().getName().equals(ProviderManagerExt.class.getName())) {
            throw new RuntimeException("ProviderManager set to the default one");
        }
    }
}

