/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.java.sip.communicator.impl.protocol.icq.IcqActivator;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.Logger;

public class AimStatusEnum
extends PresenceStatus {
    private static Logger logger = Logger.getLogger(AimStatusEnum.class);
    public static final AimStatusEnum ONLINE = new AimStatusEnum(65, "Online", AimStatusEnum.getImageInBytes("service.protocol.aim.AIM_16x16"));
    public static final AimStatusEnum INVISIBLE = new AimStatusEnum(45, "Invisible", AimStatusEnum.getImageInBytes("service.protocol.aim.INVISIBLE_STATUS_ICON"));
    public static final AimStatusEnum AWAY = new AimStatusEnum(40, "Away", AimStatusEnum.getImageInBytes("service.protocol.aim.AWAY_STATUS_ICON"));
    public static final AimStatusEnum OFFLINE = new AimStatusEnum(0, "Offline", AimStatusEnum.getImageInBytes("service.protocol.aim.OFFLINE_STATUS_ICON"));
    public static final ArrayList<AimStatusEnum> aimStatusSet = new ArrayList();

    protected AimStatusEnum(int status, String statusName, byte[] statusIcon) {
        super(status, statusName, statusIcon);
    }

    private static byte[] getImageInBytes(String imageID) {
        InputStream in = IcqActivator.getResources().getImageInputStream(imageID);
        if (in == null) {
            return null;
        }
        byte[] image = null;
        try {
            image = new byte[in.available()];
            in.read(image);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load image:" + imageID), (Throwable)e);
        }
        return image;
    }

    static {
        aimStatusSet.add(ONLINE);
        aimStatusSet.add(INVISIBLE);
        aimStatusSet.add(AWAY);
        aimStatusSet.add(OFFLINE);
    }
}

