/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.icq.FileTransferImpl;
import net.java.sip.communicator.impl.protocol.icq.IncomingFileTransferRequestIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.OperationSetPersistentPresenceIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.FileTransferState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.OutgoingFileTransfer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionEventListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionManager;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionManagerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.BuddyCancelledEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;

public class OperationSetFileTransferIcqImpl
implements OperationSetFileTransfer,
RvConnectionManagerListener {
    private static final Logger logger = Logger.getLogger(OperationSetFileTransferIcqImpl.class);
    private ProtocolProviderServiceIcqImpl icqProvider = null;
    private ArrayList<FileTransferListener> fileTransferListeners = new ArrayList();

    public OperationSetFileTransferIcqImpl(ProtocolProviderServiceIcqImpl icqProvider) {
        this.icqProvider = icqProvider;
        icqProvider.addRegistrationStateChangeListener(new RegistrationStateListener());
    }

    public FileTransfer sendFile(Contact toContact, File file) throws IllegalStateException, IllegalArgumentException {
        this.assertConnected();
        if (file.length() > this.getMaximumFileLength()) {
            throw new IllegalArgumentException("File length exceeds the allowed one for this protocol");
        }
        AimConnection aimConnection = this.icqProvider.getAimConnection();
        OutgoingFileTransfer outgoingFileTransfer = aimConnection.getIcbmService().getRvConnectionManager().createOutgoingFileTransfer(new Screenname(toContact.getAddress()));
        String id = String.valueOf(outgoingFileTransfer.getRvSessionInfo().getRvSession().getRvSessionId());
        FileTransferImpl outFileTransfer = new FileTransferImpl(outgoingFileTransfer, id, toContact, file, 2);
        try {
            outgoingFileTransfer.setSingleFile(new File(file.getPath()));
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error sending file", (Throwable)e);
            }
            return null;
        }
        FileTransferCreatedEvent event = new FileTransferCreatedEvent((FileTransfer)outFileTransfer, new Date());
        this.fireFileTransferCreated(event);
        outgoingFileTransfer.sendRequest(new InvitationMessage(""));
        outFileTransfer.fireStatusChangeEvent(6);
        return outFileTransfer;
    }

    public FileTransfer sendFile(Contact toContact, Contact fromContact, String remotePath, String localPath) throws IllegalStateException, IllegalArgumentException {
        return this.sendFile(toContact, new File(localPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransferListener(FileTransferListener listener) {
        ArrayList<FileTransferListener> arrayList = this.fileTransferListeners;
        synchronized (arrayList) {
            if (!this.fileTransferListeners.contains(listener)) {
                this.fileTransferListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransferListener(FileTransferListener listener) {
        ArrayList<FileTransferListener> arrayList = this.fileTransferListeners;
        synchronized (arrayList) {
            this.fileTransferListeners.remove(listener);
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.icqProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to send a file.");
        }
        if (!this.icqProvider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to send a file.");
        }
    }

    @Override
    public void handleNewIncomingConnection(RvConnectionManager manager, IncomingRvConnection transfer) {
        if (transfer instanceof IncomingFileTransfer) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Incoming Icq file transfer request " + transfer.getClass()));
            }
            if (!(transfer instanceof IncomingFileTransfer)) {
                logger.warn((Object)"Wrong file transfer.");
                return;
            }
            OperationSetPersistentPresenceIcqImpl opSetPersPresence = (OperationSetPersistentPresenceIcqImpl)this.icqProvider.getOperationSet(OperationSetPersistentPresence.class);
            Contact sender = opSetPersPresence.findContactByID(transfer.getBuddyScreenname().getFormatted());
            IncomingFileTransfer incomingFileTransfer = (IncomingFileTransfer)transfer;
            final Date newDate = new Date();
            final IncomingFileTransferRequestIcqImpl req = new IncomingFileTransferRequestIcqImpl(this.icqProvider, this, incomingFileTransfer, sender, newDate);
            transfer.addEventListener(new RvConnectionEventListener(){

                @Override
                public void handleEventWithStateChange(RvConnection transfer, RvConnectionState state, RvConnectionEvent event) {
                    if (state == FileTransferState.FAILED && event instanceof BuddyCancelledEvent) {
                        OperationSetFileTransferIcqImpl.this.fireFileTransferRequestCanceled(new FileTransferRequestEvent((OperationSetFileTransfer)OperationSetFileTransferIcqImpl.this, req, newDate));
                    }
                }

                @Override
                public void handleEvent(RvConnection arg0, RvConnectionEvent arg1) {
                }
            });
            this.fireFileTransferRequest(new FileTransferRequestEvent((OperationSetFileTransfer)this, (IncomingFileTransferRequest)req, newDate));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFileTransferRequest(FileTransferRequestEvent event) {
        Iterator<FileTransferListener> listeners = null;
        ArrayList<FileTransferListener> arrayList = this.fileTransferListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferRequestRejected(FileTransferRequestEvent event) {
        Iterator<FileTransferListener> listeners = null;
        ArrayList<FileTransferListener> arrayList = this.fileTransferListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestRejected(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferRequestCanceled(FileTransferRequestEvent event) {
        Iterator<FileTransferListener> listeners = null;
        ArrayList<FileTransferListener> arrayList = this.fileTransferListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestCanceled(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferCreated(FileTransferCreatedEvent event) {
        Iterator<FileTransferListener> listeners = null;
        ArrayList<FileTransferListener> arrayList = this.fileTransferListeners;
        synchronized (arrayList) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferCreated(event);
        }
    }

    public long getMaximumFileLength() {
        return 0x80000000L;
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                AimConnection aimConnection = OperationSetFileTransferIcqImpl.this.icqProvider.getAimConnection();
                aimConnection.getIcbmService().getRvConnectionManager().addConnectionManagerListener(OperationSetFileTransferIcqImpl.this);
            }
        }
    }
}

