/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icon.IconCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class UploadIconCmd
extends IconCommand {
    private static final int TYPE_ICON_DATA = 1;
    private final Writable iconWritable;
    private final ByteBlock iconData;

    protected UploadIconCmd(SnacPacket packet) {
        super(2);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        Tlv iconTlv = chain.getLastTlv(1);
        this.iconData = iconTlv != null ? iconTlv.getData() : null;
        this.iconWritable = this.iconData;
    }

    public UploadIconCmd(Writable iconData) {
        super(2);
        this.iconWritable = iconData;
        this.iconData = null;
    }

    public final ByteBlock getIconData() {
        return this.iconData;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.iconWritable != null) {
            new Tlv(1, this.iconWritable).write(out);
        }
    }

    public String toString() {
        return "UploadIconCmd";
    }
}

