/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.info;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.oscar.oscar.service.info.BuddyHashHolder;
import net.kano.joustsim.oscar.oscar.service.info.CertificateInfoTrustListener;
import net.kano.joustsim.trust.BuddyCertificateInfo;
import net.kano.joustsim.trust.CertificateHolder;
import net.kano.joustsim.trust.DefaultCertificateHolder;
import net.kano.joustsim.trust.TrustedCertificateInfo;
import net.kano.joustsim.trust.TrustedCertificatesListener;
import net.kano.joustsim.trust.TrustedCertificatesTracker;

public class CertificateInfoTrustManager {
    private static final Logger LOGGER = Logger.getLogger(CertificateInfoTrustManager.class.getName());
    private final TrustedCertificatesTracker certTrustMgr;
    private Map<CertificateHolder, Set<BuddyCertificateInfoHolder>> certInfoTrust = new HashMap<CertificateHolder, Set<BuddyCertificateInfoHolder>>();
    private Map<BuddyHashHolder, BuddyCertificateInfoHolder> certHolders = new HashMap<BuddyHashHolder, BuddyCertificateInfoHolder>();
    private CopyOnWriteArrayList<CertificateInfoTrustListener> listeners = new CopyOnWriteArrayList();

    public CertificateInfoTrustManager(TrustedCertificatesTracker certTrustMgr) {
        DefensiveTools.checkNull(certTrustMgr, "certTrustMgr");
        this.certTrustMgr = certTrustMgr;
        certTrustMgr.addTrustedCertsListener(new TrustedCertificatesListener(){

            public void certificateTrusted(TrustedCertificatesTracker manager, TrustedCertificateInfo info) {
                CertificateInfoTrustManager.this.handleCertChange(info.getCertificate());
            }

            public void certificateNoLongerTrusted(TrustedCertificatesTracker manager, TrustedCertificateInfo info) {
                CertificateInfoTrustManager.this.handleCertChange(info.getCertificate());
            }
        });
    }

    public void addTrustListener(CertificateInfoTrustListener l) {
        this.listeners.addIfAbsent(l);
    }

    public void removeTrustListener(CertificateInfoTrustListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCertChange(X509Certificate cert) {
        assert (!Thread.holdsLock(this));
        DefaultCertificateHolder holder = new DefaultCertificateHolder(cert);
        ArrayList<BuddyCertificateInfoHolder> updated = new ArrayList<BuddyCertificateInfoHolder>();
        CertificateInfoTrustManager certificateInfoTrustManager = this;
        synchronized (certificateInfoTrustManager) {
            Set<BuddyCertificateInfoHolder> certinfos = this.certInfoTrust.get(holder);
            for (BuddyCertificateInfoHolder infoHolder : certinfos) {
                if (!this.updateTrusted(infoHolder)) continue;
                updated.add(infoHolder);
            }
        }
        for (BuddyCertificateInfoHolder infoHolder : updated) {
            if (infoHolder.isTrusted()) {
                this.fireCertInfoTrustedEvent(infoHolder);
                continue;
            }
            this.fireCertInfoNoLongerTrustedEvent(infoHolder);
        }
    }

    private synchronized boolean updateTrusted(BuddyCertificateInfoHolder infoHolder) {
        boolean isTrusted;
        DefensiveTools.checkNull(infoHolder, "infoHolder");
        boolean wasTrusted = infoHolder.isTrusted();
        BuddyCertificateInfo info = infoHolder.getInfo();
        X509Certificate encCert = info.getEncryptionCertificate();
        X509Certificate signingCert = info.getSigningCertificate();
        boolean encTrusted = this.certTrustMgr.isTrusted(encCert);
        boolean signTrusted = this.certTrustMgr.isTrusted(signingCert);
        boolean bl = isTrusted = encTrusted && signTrusted;
        if (isTrusted != wasTrusted) {
            infoHolder.setTrusted(isTrusted);
            return true;
        }
        return false;
    }

    private void fireCertInfoTrustedEvent(BuddyCertificateInfoHolder infoHolder) {
        assert (!Thread.holdsLock(this));
        BuddyCertificateInfo buddyCertInfo = infoHolder.getInfo();
        for (CertificateInfoTrustListener listener : this.listeners) {
            listener.certificateInfoTrusted(this, buddyCertInfo);
        }
    }

    private void fireCertInfoNoLongerTrustedEvent(BuddyCertificateInfoHolder infoHolder) {
        assert (!Thread.holdsLock(this));
        BuddyCertificateInfo buddyCertInfo = infoHolder.getInfo();
        for (CertificateInfoTrustListener listener : this.listeners) {
            listener.certificateInfoNoLongerTrusted(this, buddyCertInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackedCertificateInfo(BuddyCertificateInfo certInfo) {
        boolean trusted;
        DefensiveTools.checkNull(certInfo, "certInfo");
        if (!certInfo.hasBothCertificates()) {
            throw new IllegalArgumentException("certificate information object does not contain both encryption and signing certificates");
        }
        X509Certificate encCert = certInfo.getEncryptionCertificate();
        X509Certificate signingCert = certInfo.getSigningCertificate();
        assert (encCert != null && signingCert != null);
        BuddyHashHolder hashHolder = new BuddyHashHolder(certInfo.getBuddy(), certInfo.getCertificateInfoHash());
        BuddyCertificateInfoHolder holder = new BuddyCertificateInfoHolder(certInfo);
        CertificateInfoTrustManager certificateInfoTrustManager = this;
        synchronized (certificateInfoTrustManager) {
            this.certHolders.put(hashHolder, holder);
            this.associateCert(encCert, holder);
            this.associateCert(signingCert, holder);
        }
        this.certTrustMgr.addTrackedCertificate(encCert);
        if (signingCert != encCert) {
            this.certTrustMgr.addTrackedCertificate(signingCert);
        }
        if (trusted = this.updateTrusted(holder)) {
            LOGGER.fine("certificate for " + certInfo.getBuddy() + " is trusted");
            this.fireCertInfoTrustedEvent(holder);
        } else {
            LOGGER.fine("certificate for " + certInfo.getBuddy() + " is NOT trusted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrackedCertificateInfo(BuddyCertificateInfo certInfo) {
        boolean wasTrusted;
        BuddyCertificateInfoHolder holder;
        DefensiveTools.checkNull(certInfo, "certInfo");
        X509Certificate encCert = certInfo.getEncryptionCertificate();
        X509Certificate signingCert = certInfo.getSigningCertificate();
        CertificateInfoTrustManager certificateInfoTrustManager = this;
        synchronized (certificateInfoTrustManager) {
            this.certTrustMgr.removeTrackedCertificate(encCert);
            this.certTrustMgr.removeTrackedCertificate(signingCert);
            this.disassociateCert(signingCert, certInfo);
            this.disassociateCert(encCert, certInfo);
            BuddyHashHolder hashHolder = new BuddyHashHolder(certInfo.getBuddy(), certInfo.getCertificateInfoHash());
            holder = this.certHolders.remove(hashHolder);
            wasTrusted = holder != null && holder.isTrusted();
        }
        if (wasTrusted) {
            this.fireCertInfoNoLongerTrustedEvent(holder);
        }
    }

    private synchronized void disassociateCert(X509Certificate cert, BuddyCertificateInfo certInfo) {
        DefaultCertificateHolder certHolder = new DefaultCertificateHolder(cert);
        Set<BuddyCertificateInfoHolder> associated = this.certInfoTrust.get(certHolder);
        if (associated == null) {
            return;
        }
        Iterator<BuddyCertificateInfoHolder> it = associated.iterator();
        while (it.hasNext()) {
            BuddyCertificateInfoHolder holder = it.next();
            if (!holder.getInfo().equals(certInfo)) continue;
            it.remove();
        }
    }

    private synchronized boolean associateCert(X509Certificate cert, BuddyCertificateInfoHolder infoHolder) {
        DefaultCertificateHolder certHolder = new DefaultCertificateHolder(cert);
        Set<BuddyCertificateInfoHolder> associated = this.certInfoTrust.get(certHolder);
        if (associated == null) {
            associated = new HashSet<BuddyCertificateInfoHolder>();
            this.certInfoTrust.put(certHolder, associated);
        }
        return associated.add(infoHolder);
    }

    public synchronized boolean isTrusted(BuddyCertificateInfo certInfo) {
        BuddyHashHolder hashHolder = new BuddyHashHolder(certInfo.getBuddy(), certInfo.getCertificateInfoHash());
        BuddyCertificateInfoHolder holder = this.certHolders.get(hashHolder);
        return holder != null && holder.isTrusted();
    }

    private static class BuddyCertificateInfoHolder {
        private final BuddyCertificateInfo info;
        private boolean trusted = false;

        public BuddyCertificateInfoHolder(BuddyCertificateInfo info) {
            this.info = info;
        }

        public BuddyCertificateInfo getInfo() {
            return this.info;
        }

        public synchronized boolean isTrusted() {
            return this.trusted;
        }

        public synchronized void setTrusted(boolean trusted) {
            this.trusted = trusted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BuddyCertificateInfoHolder)) {
                return false;
            }
            BuddyCertificateInfoHolder buddyCertificateInfoHolder = (BuddyCertificateInfoHolder)o;
            return this.info.equals(buddyCertificateInfoHolder.info);
        }

        public int hashCode() {
            return this.info.hashCode();
        }
    }
}

