/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.connectioninfo;

import java.awt.Container;
import java.awt.Dimension;
import java.security.cert.Certificate;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.java.sip.communicator.plugin.connectioninfo.ConnectionInfoActivator;
import net.java.sip.communicator.plugin.connectioninfo.ConnectionInfoMenuItemComponent;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.ViewCertificateFrame;
import net.java.sip.communicator.service.protocol.OperationSetConnectionInfo;
import net.java.sip.communicator.service.protocol.OperationSetTLS;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;

public class ConnectionDetailsPanel
extends TransparentPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Logger.getLogger(ConnectionDetailsPanel.class);
    private final ResourceManagementService R;
    final ProtocolProviderService protocolProvider;
    private final ConnectionInfoMenuItemComponent.ConnectionInfoDialog dialog;
    private final JEditorPane infoTextPane;
    private final String CERTIFICATE_URL = "jitsi://viewCertificate";

    public ConnectionDetailsPanel(ConnectionInfoMenuItemComponent.ConnectionInfoDialog dialog, ProtocolProviderService protocolProvider) {
        this.dialog = dialog;
        this.R = ConnectionInfoActivator.R;
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(600, 400));
        this.protocolProvider = protocolProvider;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.infoTextPane = new JEditorPane();
        this.infoTextPane.putClientProperty("JEditorPane.honorDisplayProperties", true);
        this.infoTextPane.setOpaque(false);
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setContentType("text/html");
        this.infoTextPane.addHyperlinkListener(this);
        if (protocolProvider.isRegistered()) {
            this.loadDetails();
        }
        this.add(this.infoTextPane);
    }

    public void loadDetails() {
        OperationSetTLS opSetTls;
        TransportProtocol preferredTransport;
        StringBuilder buff = new StringBuilder();
        buff.append("<html><body><p align=\"left\"><font size=\"3\">");
        buff.append(this.getLineString(this.R.getI18NString("service.gui.PROTOCOL"), this.protocolProvider.getProtocolName()));
        OperationSetConnectionInfo opSetConnectionInfo = (OperationSetConnectionInfo)this.protocolProvider.getOperationSet(OperationSetConnectionInfo.class);
        if (opSetConnectionInfo != null) {
            buff.append(this.getLineString(this.R.getI18NString("service.gui.ADDRESS"), opSetConnectionInfo.getServerAddress() == null ? "" : opSetConnectionInfo.getServerAddress().getHostName()));
            buff.append(this.getLineString(this.R.getI18NString("service.gui.PORT"), opSetConnectionInfo.getServerAddress() == null ? "" : String.valueOf(opSetConnectionInfo.getServerAddress().getPort())));
        }
        if ((preferredTransport = this.protocolProvider.getTransportProtocol()) != TransportProtocol.UNKNOWN) {
            buff.append(this.getLineString(this.R.getI18NString("service.gui.callinfo.CALL_TRANSPORT"), preferredTransport.toString()));
        }
        if ((opSetTls = (OperationSetTLS)this.protocolProvider.getOperationSet(OperationSetTLS.class)) != null) {
            buff.append(this.getLineString(this.R.getI18NString("service.gui.callinfo.TLS_PROTOCOL"), opSetTls.getProtocol()));
            buff.append(this.getLineString(this.R.getI18NString("service.gui.callinfo.TLS_CIPHER_SUITE"), opSetTls.getCipherSuite()));
            buff.append("<b><a href=\"").append("jitsi://viewCertificate").append("\">").append(this.R.getI18NString("service.gui.callinfo.VIEW_CERTIFICATE")).append("</a></b><br/>");
        }
        buff.append("</font></p></body></html>");
        this.infoTextPane.setText(buff.toString());
        this.infoTextPane.revalidate();
        this.infoTextPane.repaint();
    }

    private String getLineString(String labelText, String infoText) {
        return "<b>" + labelText + "</b> : " + infoText + "<br/>";
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "jitsi://viewCertificate".equals(e.getDescription())) {
            Certificate[] chain = ((OperationSetTLS)this.protocolProvider.getOperationSet(OperationSetTLS.class)).getServerCertificates();
            ViewCertificateFrame certFrame = new ViewCertificateFrame(chain, null, this.R.getI18NString("service.gui.callinfo.TLS_CERTIFICATE_CONTENT"));
            certFrame.setVisible(true);
        }
    }

    public ProtocolProviderService getProtocolProvider() {
        return this.protocolProvider;
    }
}

