/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GDataProtocol;
import com.google.gdata.client.Query;
import com.google.gdata.client.batch.BatchInterruptedException;
import com.google.gdata.client.http.HttpGDataRequest;
import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IAtom;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.ILink;
import com.google.gdata.data.ParseSource;
import com.google.gdata.data.introspection.IServiceDocument;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataContext;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.Schema;
import com.google.gdata.model.atom.Feed;
import com.google.gdata.model.batch.BatchUtils;
import com.google.gdata.model.transforms.atom.AtomVersionTransforms;
import com.google.gdata.model.transforms.atompub.AtompubVersionTransforms;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.util.common.net.UriParameterMap;
import com.google.gdata.wireformats.AltFormat;
import com.google.gdata.wireformats.AltRegistry;
import com.google.gdata.wireformats.StreamProperties;
import com.google.gdata.wireformats.input.AtomDualParser;
import com.google.gdata.wireformats.input.AtomServiceDualParser;
import com.google.gdata.wireformats.input.InputParser;
import com.google.gdata.wireformats.input.InputProperties;
import com.google.gdata.wireformats.output.AtomDualGenerator;
import com.google.gdata.wireformats.output.AtomServiceDualGenerator;
import com.google.gdata.wireformats.output.OutputGenerator;
import com.google.gdata.wireformats.output.OutputProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Map;

public class Service {
    private static final String SERVICE_VERSION = "GData-Java/" + Service.class.getPackage().getImplementationVersion() + "(gzip)";
    private static final Version CORE_VERSION = Service.initServiceVersion(Service.class, Versions.V1);
    private static final AltRegistry BASE_REGISTRY = new AltRegistry();
    private Version protocolVersion;
    protected ExtensionProfile extProfile = new ExtensionProfile();
    protected final MetadataRegistry metadataRegistry;
    protected GDataRequestFactory requestFactory = new HttpGDataRequest.Factory();
    private ContentType contentType = ContentType.ATOM;
    protected int connectTimeout = -1;
    int readTimeout = -1;
    private AltRegistry altRegistry = BASE_REGISTRY;
    private boolean strictValidation = true;

    protected static Version initServiceVersion(Class<? extends Service> serviceClass, Version defaultVersion) {
        VersionRegistry versionRegistry = VersionRegistry.ensureRegistry();
        Version v = null;
        try {
            v = versionRegistry.getVersion(serviceClass);
        }
        catch (IllegalStateException ise) {
            try {
                v = VersionRegistry.getVersionFromProperty(serviceClass);
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (v == null) {
                v = defaultVersion;
            }
            versionRegistry.addDefaultVersion(v, false);
        }
        return v;
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(Service.class);
    }

    private static Version initProtocolVersion(Class<? extends Service> serviceClass) {
        VersionRegistry registry = VersionRegistry.get();
        for (Class<? extends Service> checkClass = serviceClass; checkClass != Service.class; checkClass = checkClass.getSuperclass()) {
            try {
                return registry.getVersion(checkClass);
            }
            catch (IllegalStateException ise) {
                continue;
            }
        }
        try {
            return Service.getVersion();
        }
        catch (IllegalStateException ise) {
            return CORE_VERSION;
        }
    }

    public Service() {
        this.requestFactory.setHeader("User-Agent", this.getServiceVersion());
        this.protocolVersion = Service.initProtocolVersion(this.getClass());
        new com.google.gdata.data.Feed().declareExtensions(this.extProfile);
        this.metadataRegistry = new MetadataRegistry();
        Feed.registerMetadata(this.metadataRegistry);
        AtomVersionTransforms.addTransforms(this.metadataRegistry);
        AtompubVersionTransforms.addTransforms(this.metadataRegistry);
    }

    public static AltRegistry getDefaultAltRegistry() {
        return BASE_REGISTRY;
    }

    public Version getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(Version v) {
        if (!this.protocolVersion.getServiceClass().equals(v.getServiceClass())) {
            throw new IllegalArgumentException("Invalid service class, was: " + v.getServiceClass() + ", expected: " + this.protocolVersion.getServiceClass());
        }
        this.protocolVersion = v;
    }

    protected void startVersionScope() {
        VersionRegistry.get().setThreadVersion(this.protocolVersion);
    }

    protected void endVersionScope() {
        VersionRegistry.get().resetThreadVersion();
    }

    public String getServiceVersion() {
        return SERVICE_VERSION;
    }

    public ExtensionProfile getExtensionProfile() {
        return this.extProfile;
    }

    public void setExtensionProfile(ExtensionProfile v) {
        this.extProfile = v;
    }

    public MetadataRegistry getMetadataRegistry() {
        return this.metadataRegistry;
    }

    public Schema getSchema() {
        return this.metadataRegistry.createSchema();
    }

    public GDataRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public void setRequestFactory(GDataRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void setHeader(String header, String value) {
        this.getRequestFactory().setHeader(header, value);
    }

    public void setPrivateHeader(String header, String value) {
        this.getRequestFactory().setPrivateHeader(header, value);
    }

    public void setOAuthProxyHeaders(Map<String, String> headers) {
        for (String key : headers.keySet()) {
            this.setHeader(key, headers.get(key));
        }
    }

    public void useSsl() {
        if (!(this.requestFactory instanceof HttpGDataRequest.Factory)) {
            throw new UnsupportedOperationException("Not a http transport");
        }
        ((HttpGDataRequest.Factory)this.requestFactory).useSsl();
    }

    public void setAcceptLanguage(String acceptedLanguages) {
        this.requestFactory.setHeader("Accept-Language", acceptedLanguages);
    }

    public GDataRequest createRequest(GDataRequest.RequestType type, URL requestUrl, ContentType inputType) throws IOException, ServiceException {
        GDataRequest request = this.requestFactory.getRequest(type, requestUrl, inputType);
        this.setTimeouts(request);
        return request;
    }

    protected GDataRequest createRequest(Query query, ContentType inputType) throws IOException, ServiceException {
        GDataRequest request = this.requestFactory.getRequest(query, inputType);
        this.setTimeouts(request);
        return request;
    }

    public void setTimeouts(GDataRequest request) {
        if (this.connectTimeout >= 0) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout >= 0) {
            request.setReadTimeout(this.readTimeout);
        }
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout value cannot be negative");
        }
        this.connectTimeout = timeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout value cannot be negative");
        }
        this.readTimeout = timeout;
    }

    public AltRegistry getAltRegistry() {
        return this.altRegistry;
    }

    public void setAltRegistry(AltRegistry altRegistry) {
        this.altRegistry = altRegistry;
    }

    public boolean getStrictValidation() {
        return this.strictValidation;
    }

    public void setStrictValidation(boolean strictValidation) {
        this.strictValidation = strictValidation;
    }

    protected <T> Class<T> classOf(T object) {
        return object.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends IServiceDocument> S introspect(URL feedUrl, Class<S> serviceClass) throws IOException, ServiceException {
        String feedQuery = feedUrl.getQuery();
        String altParam = "alt=" + AltFormat.ATOM_SERVICE.getName();
        if (feedQuery == null || feedQuery.indexOf(altParam) == -1) {
            char appendChar = feedQuery == null ? (char)'?' : '&';
            feedUrl = new URL(feedUrl.toString() + appendChar + altParam);
        }
        GDataRequest request = this.createFeedRequest(feedUrl);
        try {
            this.startVersionScope();
            request.execute();
            IServiceDocument iServiceDocument = (IServiceDocument)this.parseResponseData(request, serviceClass);
            return (S)iServiceDocument;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(feedUrl);
        return this.getFeed(request, feedClass, ifModifiedSince);
    }

    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass, String etag) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(feedUrl);
        return this.getFeed(request, feedClass, etag);
    }

    public <F extends IFeed> F getFeed(URL feedUrl, Class<F> feedClass) throws IOException, ServiceException {
        return this.getFeed(feedUrl, feedClass, (String)null);
    }

    public <F extends IFeed> F getFeed(Query query, Class<F> feedClass) throws IOException, ServiceException {
        return this.getFeed(query, feedClass, (String)null);
    }

    public <F extends IFeed> F getFeed(Query query, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(query);
        return this.getFeed(request, feedClass, ifModifiedSince);
    }

    public <F extends IFeed> F getFeed(Query query, Class<F> feedClass, String etag) throws IOException, ServiceException {
        GDataRequest request = this.createFeedRequest(query);
        return this.getFeed(request, feedClass, etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends IFeed> F getFeed(GDataRequest request, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        try {
            this.startVersionScope();
            request.setIfModifiedSince(ifModifiedSince);
            request.execute();
            IFeed iFeed = (IFeed)this.parseResponseData(request, feedClass);
            return (F)iFeed;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends IFeed> F getFeed(GDataRequest request, Class<F> feedClass, String etag) throws IOException, ServiceException {
        try {
            this.startVersionScope();
            request.setEtag(etag);
            request.execute();
            IFeed iFeed = (IFeed)this.parseResponseData(request, feedClass);
            return (F)iFeed;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    public GDataRequest createFeedRequest(URL feedUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.QUERY, feedUrl, this.contentType);
    }

    public <F extends IFeed> F query(Query query, Class<F> feedClass) throws IOException, ServiceException {
        return this.query(query, feedClass, (String)null);
    }

    public <F extends IFeed> F query(Query query, Class<F> feedClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        return this.getFeed(query, feedClass, ifModifiedSince);
    }

    public <F extends IFeed> F query(Query query, Class<F> feedClass, String etag) throws IOException, ServiceException {
        return this.getFeed(query, feedClass, etag);
    }

    public GDataRequest createFeedRequest(Query query) throws IOException, ServiceException {
        return this.createRequest(query, this.contentType);
    }

    public <E extends IEntry> E getEntry(URL entryUrl, Class<E> entryClass) throws IOException, ServiceException {
        return this.getEntry(entryUrl, entryClass, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> E getEntry(URL entryUrl, Class<E> entryClass, DateTime ifModifiedSince) throws IOException, ServiceException {
        Object entrySource = null;
        GDataRequest request = this.createEntryRequest(entryUrl);
        try {
            this.startVersionScope();
            request.setIfModifiedSince(ifModifiedSince);
            request.execute();
            IEntry iEntry = (IEntry)this.parseResponseData(request, entryClass);
            return (E)iEntry;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> E getEntry(URL entryUrl, Class<E> entryClass, String etag) throws IOException, ServiceException {
        Object entrySource = null;
        GDataRequest request = this.createEntryRequest(entryUrl);
        try {
            this.startVersionScope();
            request.setEtag(etag);
            request.execute();
            IEntry iEntry = (IEntry)this.parseResponseData(request, entryClass);
            return (E)iEntry;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    public GDataRequest createEntryRequest(URL entryUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.QUERY, entryUrl, this.contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> E insert(URL feedUrl, E entry) throws IOException, ServiceException {
        if (entry == null) {
            throw new NullPointerException("Must supply entry");
        }
        GDataRequest request = this.createInsertRequest(feedUrl);
        try {
            this.startVersionScope();
            this.writeRequestData(request, entry);
            request.execute();
            E e = this.parseResponseData(request, this.classOf(entry));
            return e;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <F extends IFeed> F batch(URL feedUrl, F inputFeed) throws IOException, ServiceException, BatchInterruptedException {
        GDataRequest request = this.createInsertRequest(feedUrl);
        try {
            this.startVersionScope();
            this.writeRequestData(request, inputFeed);
            request.execute();
            F resultFeed = this.parseResponseData(request, this.classOf(inputFeed));
            int count = resultFeed.getEntries().size();
            BatchUtils.throwIfInterrupted(resultFeed);
            F f = resultFeed;
            return f;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    public GDataRequest createInsertRequest(URL feedUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.INSERT, feedUrl, this.contentType);
    }

    public GDataRequest createBatchRequest(URL feedUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.BATCH, feedUrl, this.contentType);
    }

    public <E extends IEntry> E update(URL entryUrl, E entry) throws IOException, ServiceException {
        String etag = entry.getEtag();
        if (GDataProtocol.isWeakEtag(etag)) {
            etag = null;
        }
        return this.update(entryUrl, entry, etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> E update(URL entryUrl, E entry, String etag) throws IOException, ServiceException {
        GDataRequest request = this.createUpdateRequest(entryUrl);
        try {
            this.startVersionScope();
            request.setEtag(etag);
            this.writeRequestData(request, entry);
            request.execute();
            E e = this.parseResponseData(request, this.classOf(entry));
            return e;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    public GDataRequest createUpdateRequest(URL entryUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.UPDATE, entryUrl, this.contentType);
    }

    public <E extends IEntry> E patch(URL entryUrl, String fields, E entry) throws IOException, ServiceException {
        String etag = null;
        if (entry != null && GDataProtocol.isWeakEtag(etag = entry.getEtag())) {
            etag = null;
        }
        return this.patch(entryUrl, fields, entry, etag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends IEntry> E patch(URL entryUrl, String fields, E entry, String etag) throws IOException, ServiceException {
        GDataRequest request = this.createPatchRequest(entryUrl);
        try {
            this.startVersionScope();
            request.setEtag(etag);
            entry.setSelectedFields(fields);
            this.writeRequestData(request, entry);
            request.execute();
            E e = this.parseResponseData(request, this.classOf(entry));
            return e;
        }
        finally {
            this.endVersionScope();
            request.end();
        }
    }

    public GDataRequest createPatchRequest(URL entryUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.PATCH, entryUrl, ContentType.APPLICATION_XML);
    }

    public void delete(URL resourceUrl) throws IOException, ServiceException {
        this.delete(resourceUrl, null);
    }

    public void delete(URI resourceUri) throws IOException, ServiceException {
        this.delete(resourceUri.toURL(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URL resourceUrl, String etag) throws IOException, ServiceException {
        GDataRequest request = this.createDeleteRequest(resourceUrl);
        try {
            this.startVersionScope();
            request.setEtag(etag);
            request.execute();
        }
        finally {
            request.end();
        }
    }

    public void delete(URI resourceUri, String etag) throws IOException, ServiceException {
        this.delete(resourceUri.toURL(), etag);
    }

    public GDataRequest createDeleteRequest(URL entryUrl) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.DELETE, entryUrl, this.contentType);
    }

    @Deprecated
    public InputStream getStreamFromLink(ILink link) throws IOException, ServiceException {
        GDataRequest request = this.createLinkQueryRequest(link);
        request.execute();
        InputStream resultStream = request.getResponseStream();
        return resultStream;
    }

    public GDataRequest createLinkQueryRequest(ILink link) throws IOException, ServiceException {
        return this.createRequest(GDataRequest.RequestType.QUERY, new URL(link.getHref()), null);
    }

    public void writeRequestData(GDataRequest req, Object source) throws IOException {
        this.writeRequestData(req, new ClientOutputProperties(req, source), source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRequestData(GDataRequest req, ClientOutputProperties outProps, Object source) throws IOException {
        boolean disableValidation;
        AltFormat outputFormat = this.altRegistry.lookupType(outProps.getContentType());
        if (outputFormat == null) {
            outputFormat = this.altRegistry.lookupName(AltFormat.MEDIA.getName());
        }
        if (outputFormat == null) {
            throw new IllegalStateException("Unsupported request type: " + outProps.getContentType());
        }
        OutputGenerator<?> generator = this.altRegistry.getGenerator(outputFormat);
        if (!generator.getSourceType().isAssignableFrom(source.getClass())) {
            throw new IllegalArgumentException("Invalid source type: expected: " + generator.getSourceType() + " but got: " + source.getClass() + " for output format " + outputFormat);
        }
        OutputGenerator<?> typedGenerator = generator;
        boolean bl = disableValidation = !this.strictValidation || outputFormat.equals(AltFormat.APPLICATION_XML);
        if (disableValidation) {
            AbstractExtension.disableStrictValidation();
        }
        try {
            typedGenerator.generate(req.getRequestStream(), outProps, source);
        }
        finally {
            if (disableValidation) {
                AbstractExtension.enableStrictValidation();
            }
        }
    }

    public <E> E parseResponseData(GDataRequest req, Class<E> resultType) throws IOException, ServiceException {
        ClientInputProperties inputProperties = new ClientInputProperties(req, resultType);
        return this.parseResponseData(req.getParseSource(), inputProperties, resultType);
    }

    protected <E> E parseResponseData(ParseSource source, ContentType responseType, Class<E> resultType) throws IOException, ServiceException {
        ClientInputProperties inputProperties = new ClientInputProperties(responseType, resultType);
        return this.parseResponseData(source, inputProperties, resultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> E parseResponseData(ParseSource source, InputProperties inputProperties, Class<E> resultType) throws IOException, ServiceException {
        E result;
        boolean disableValidation;
        Preconditions.checkNotNull("resultType", resultType);
        AltFormat inputFormat = null;
        String alt = inputProperties.getQueryParameter("alt");
        if (alt != null) {
            inputFormat = this.altRegistry.lookupName(alt);
        }
        if (inputFormat == null && (inputFormat = this.altRegistry.lookupType(inputProperties.getContentType())) == null) {
            throw new ParseException("Unrecognized content type:" + inputProperties.getContentType());
        }
        InputParser<?> inputParser = this.altRegistry.getParser(inputFormat);
        if (inputParser == null) {
            throw new ParseException("No parser for content type:" + inputFormat);
        }
        if (!inputParser.getResultType().isAssignableFrom(resultType)) {
            throw new IllegalStateException("Input parser (" + inputParser + ") does not produce expected result type: " + resultType);
        }
        InputParser<?> typedParser = inputParser;
        String fields = inputProperties.getQueryParameter("fields");
        boolean bl = disableValidation = !this.strictValidation || fields != null && !Element.class.isAssignableFrom(resultType);
        if (disableValidation) {
            AbstractExtension.disableStrictValidation();
        }
        try {
            result = typedParser.parse(source, inputProperties, resultType);
        }
        finally {
            if (disableValidation) {
                AbstractExtension.enableStrictValidation();
            }
        }
        if (result instanceof IAtom) {
            ((IAtom)result).setService(this);
        }
        return result;
    }

    private static UriParameterMap computeQueryMap(GDataRequest req) {
        String query = req.getRequestUrl().getQuery();
        if (query == null) {
            return UriParameterMap.EMPTY_MAP;
        }
        return UriParameterMap.parse(query);
    }

    static {
        BASE_REGISTRY.register(AltFormat.ATOM, new AtomDualParser(), new AtomDualGenerator());
        BASE_REGISTRY.register(AltFormat.ATOM_SERVICE, new AtomServiceDualParser(), new AtomServiceDualGenerator());
        BASE_REGISTRY.register(AltFormat.APPLICATION_XML, null, new AtomDualGenerator(AltFormat.APPLICATION_XML));
        BASE_REGISTRY.lock();
    }

    public class ClientOutputProperties
    extends ClientStreamProperties
    implements OutputProperties {
        protected final ContentType requestType;
        private ElementMetadata<?, ?> elementMetadata;

        public ClientOutputProperties(GDataRequest req, Object source) {
            super(req);
            this.requestType = req.getRequestContentType();
            this.init(source);
        }

        public ClientOutputProperties(ContentType requestType, Object source) {
            this.requestType = requestType;
            this.init(source);
        }

        private void init(Object source) {
            if (source instanceof Element) {
                Element element = (Element)source;
                ElementKey<?, ?> key = element.getElementKey();
                this.elementMetadata = Service.this.getSchema().bind(key, this.getMetadataContext());
            } else {
                this.elementMetadata = null;
            }
        }

        @Override
        public ContentType getContentType() {
            return this.requestType;
        }

        @Override
        public ElementMetadata<?, ?> getRootMetadata() {
            return this.elementMetadata;
        }

        public String getCallback() {
            return null;
        }
    }

    protected class ClientInputProperties
    extends ClientStreamProperties
    implements InputProperties {
        private final Class<?> expectType;
        protected final ContentType inputType;
        private ElementMetadata<?, ?> elementMetadata;

        protected ClientInputProperties(GDataRequest req, Class<?> expectType) throws IOException, ServiceException {
            super(req);
            this.expectType = expectType;
            this.inputType = req.getResponseContentType();
            this.init();
        }

        protected ClientInputProperties(ContentType inputType, Class<?> expectType) throws IOException, ServiceException {
            this.expectType = expectType;
            this.inputType = inputType;
            this.init();
        }

        private void init() {
            if (Element.class.isAssignableFrom(this.expectType)) {
                ElementKey<?, ?> key = Element.getDefaultKey(this.expectType.asSubclass(Element.class));
                this.elementMetadata = Service.this.getSchema().bind(key, this.getMetadataContext());
            } else {
                this.elementMetadata = null;
            }
        }

        @Override
        public ContentType getContentType() {
            return this.inputType;
        }

        @Override
        public Class<?> getRootType() {
            return this.expectType;
        }

        @Override
        public ElementMetadata<?, ?> getRootMetadata() {
            return this.elementMetadata;
        }

        @Override
        public boolean isPartial() {
            return this.getQueryParameter("fields") != null;
        }
    }

    protected abstract class ClientStreamProperties
    implements StreamProperties {
        protected final GDataRequest req;
        protected final UriParameterMap queryMap;

        protected ClientStreamProperties(GDataRequest req) {
            this.queryMap = Service.computeQueryMap(req);
            this.req = req;
        }

        protected ClientStreamProperties() {
            this.queryMap = UriParameterMap.EMPTY_MAP;
            this.req = null;
        }

        public GDataRequest getGDataRequest() {
            return this.req;
        }

        public Version getRequestVersion() {
            return Service.this.getProtocolVersion();
        }

        @Override
        public AltRegistry getAltRegistry() {
            return Service.this.getAltRegistry();
        }

        public boolean isPartial() {
            return false;
        }

        @Override
        public ExtensionProfile getExtensionProfile() {
            return Service.this.getExtensionProfile();
        }

        protected MetadataContext getMetadataContext() {
            return MetadataContext.forContext(this.getAltFormat(), null, Service.this.getProtocolVersion());
        }

        @Override
        public Collection<String> getQueryParameterNames() {
            return this.queryMap.keySet();
        }

        @Override
        public String getQueryParameter(String name) {
            return this.queryMap.getFirst(name);
        }

        protected AltFormat getAltFormat() {
            String altName = this.queryMap.getFirst("alt");
            AltFormat altFormat = this.getAltRegistry().lookupName(altName);
            return altFormat != null ? altFormat : AltFormat.ATOM;
        }

        protected UriParameterMap getParameterMap() {
            return this.queryMap;
        }
    }

    public static interface GDataRequestFactory {
        public void setHeader(String var1, String var2);

        public void setPrivateHeader(String var1, String var2);

        public void setAuthToken(AuthTokenFactory.AuthToken var1);

        public GDataRequest getRequest(GDataRequest.RequestType var1, URL var2, ContentType var3) throws IOException, ServiceException;

        public GDataRequest getRequest(Query var1, ContentType var2) throws IOException, ServiceException;
    }

    public static interface GDataRequest {
        public void setConnectTimeout(int var1);

        public void setReadTimeout(int var1);

        public void setEtag(String var1);

        public void setIfModifiedSince(DateTime var1);

        public void setHeader(String var1, String var2);

        public void setPrivateHeader(String var1, String var2);

        public URL getRequestUrl();

        public OutputStream getRequestStream() throws IOException;

        public ContentType getRequestContentType();

        public void execute() throws IOException, ServiceException;

        public ContentType getResponseContentType() throws IOException, ServiceException;

        public InputStream getResponseStream() throws IOException;

        public String getResponseHeader(String var1);

        public DateTime getResponseDateHeader(String var1);

        public ParseSource getParseSource() throws IOException, ServiceException;

        public void end();

        public static enum RequestType {
            QUERY,
            INSERT,
            UPDATE,
            PATCH,
            DELETE,
            BATCH;

        }
    }

    public static class Versions {
        public static final Version V1 = new Version(Service.class, 1, 0, new Version[0]);
        public static final Version V2 = new Version(Service.class, 2, 0, new Version[0]);
        public static final Version V2_1 = new Version(Service.class, 2, 1, new Version[0]);
        public static final Version V2_2 = new Version(Service.class, 2, 2, new Version[0]);
        public static final Version V3 = new Version(Service.class, 3, 0, new Version[0]);

        private Versions() {
        }
    }
}

